/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Lamp;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetLamps;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.desktop.ChunkUtils;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.schematic.SchematicGZip;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LampsCommand {
    private final TARDIS plugin;
    private final List<String> subs = List.of("auto", "list", "set");

    public LampsCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    boolean valid_material(String mat) {
        List allowList = this.plugin.getLampsConfig().getList("lamp_blocks");
        if (allowList == null) {
            return false;
        }
        for (Object allow : allowList) {
            String s;
            if (!(allow instanceof String) || !(s = (String)allow).equalsIgnoreCase(mat)) continue;
            return true;
        }
        return false;
    }

    public void addLampBlocks(Player owner) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", owner.getUniqueId().toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            int id = tardis.getTardisId();
            HashMap<String, Object> wherel = new HashMap<String, Object>();
            wherel.put("tardis_id", id);
            ResultSetLamps rsl = new ResultSetLamps(this.plugin, wherel, false);
            if (rsl.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)owner, TardisModule.TARDIS, "LAMP_DELETE");
                HashMap<String, Object> wheredel = new HashMap<String, Object>();
                wheredel.put("tardis_id", id);
                this.plugin.getQueryFactory().doDelete("lamps", wheredel);
            }
            String[] tc = tardis.getChunk().split(":");
            int cx = TARDISNumberParsers.parseInt(tc[1]);
            int cz = TARDISNumberParsers.parseInt(tc[2]);
            World world = TARDISAliasResolver.getWorldFromAlias(tc[0]);
            Chunk startChunk = world.getChunkAt(cx, cz);
            Schematic schm = tardis.getSchematic();
            JsonObject obj = SchematicGZip.getObject(this.plugin, "consoles", schm.getPermission(), schm.isCustom());
            if (obj != null) {
                JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
                int h = dimensions.get("height").getAsInt();
                int starty = schm.getStartY();
                int endy = starty + h;
                String w = world.getName();
                for (Chunk chunk : ChunkUtils.getConsoleChunks(startChunk, tardis.getSchematic())) {
                    int bx = chunk.getX() << 4;
                    int bz = chunk.getZ() << 4;
                    for (int xx = bx; xx < bx + 16; ++xx) {
                        for (int zz = bz; zz < bz + 16; ++zz) {
                            for (int yy = starty; yy < endy; ++yy) {
                                Material mat = world.getBlockAt(xx, yy, zz).getType();
                                if (!mat.equals((Object)Material.LIGHT)) continue;
                                String lamp = w + ":" + xx + ":" + yy + ":" + zz;
                                HashMap<String, Object> set = new HashMap<String, Object>();
                                set.put("tardis_id", id);
                                set.put("location", lamp);
                                this.plugin.getQueryFactory().doInsert("lamps", set);
                                this.plugin.getMessenger().send((CommandSender)owner, TardisModule.TARDIS, "LAMP_ADD", xx + ":" + yy + ":" + zz);
                            }
                        }
                    }
                }
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)owner, TardisModule.TARDIS, "NOT_A_TIMELORD");
        }
    }

    public void listLampBlocks(Player owner) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", owner.getUniqueId().toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            int id = tardis.getTardisId();
            HashMap<String, Object> wherel = new HashMap<String, Object>();
            wherel.put("tardis_id", id);
            ResultSetLamps rsl = new ResultSetLamps(this.plugin, wherel, true);
            if (rsl.resultSet()) {
                for (Lamp l : rsl.getData()) {
                    Block b = l.block();
                    this.plugin.getMessenger().send((CommandSender)owner, TardisModule.TARDIS, "LAMP_LIST", b.getX() + ":" + b.getY() + ":" + b.getZ());
                }
            }
        }
    }

    public void setLampBlock(Player player, int x, int y, int z, String on, String off, float p) {
        if (on.equals("_")) {
            on = "";
        } else if (!this.valid_material(on)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "LAMP_BAD_MATERIAL");
            return;
        }
        if (!off.isEmpty()) {
            if (off.equals("_")) {
                off = "";
            } else if (!this.valid_material(off)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "LAMP_BAD_MATERIAL");
                return;
            }
        }
        Float percentage = null;
        if (p != -1.0f) {
            percentage = Float.valueOf(Math.clamp(p, 0.0f, 1.0f));
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", player.getUniqueId().toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            String dimension = rs.getTardis().getChunk().split(":")[0];
            int id = tardis.getTardisId();
            HashMap<String, Object> wherel = new HashMap<String, Object>();
            wherel.put("tardis_id", id);
            wherel.put("location", dimension + ":" + x + ":" + y + ":" + z);
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("material_on", on);
            set.put("material_off", off);
            if (percentage != null) {
                set.put("percentage", percentage);
            }
            this.plugin.getQueryFactory().doUpdate("lamps", set, wherel);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "LAMP_SET_SUCCESS", wherel.get("location"));
        }
    }
}

