/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisPreset;
import me.eccentric_nz.TARDIS.doors.inner.Inner;
import me.eccentric_nz.TARDIS.doors.inner.InnerDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.inner.InnerDisplayDoorOpener;
import me.eccentric_nz.TARDIS.doors.inner.InnerDoor;
import me.eccentric_nz.TARDIS.doors.inner.InnerMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.doors.inner.InnerMinecraftDoorOpener;
import me.eccentric_nz.TARDIS.doors.outer.OuterDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterDisplayDoorOpener;
import me.eccentric_nz.TARDIS.doors.outer.OuterDoor;
import me.eccentric_nz.TARDIS.doors.outer.OuterMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterMinecraftDoorOpener;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DoorCommand {
    private final TARDIS plugin;

    public DoorCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void toggleDoors(Player player, boolean open) {
        if (!TARDISPermission.hasPermission(player, "tardis.use")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
            return;
        }
        ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
        if (!rs.fromUUID(player.getUniqueId().toString())) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_A_TIMELORD");
            return;
        }
        int id = rs.getTardisId();
        UUID playerUUID = player.getUniqueId();
        ResultSetTardisPreset rsp = new ResultSetTardisPreset(this.plugin);
        if (rsp.fromID(id)) {
            boolean outerDisplayDoor = rsp.getPreset().usesArmourStand();
            Inner innerDisplayDoor = new InnerDoor(this.plugin, id).get();
            if (open) {
                if (innerDisplayDoor.display()) {
                    new InnerDisplayDoorCloser(this.plugin).close(innerDisplayDoor.block(), id, playerUUID, true);
                } else {
                    new InnerMinecraftDoorCloser(this.plugin).close(innerDisplayDoor.block(), id, playerUUID);
                }
                if (outerDisplayDoor) {
                    new OuterDisplayDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getDisplay(), id, playerUUID, false);
                } else if (rsp.getPreset().hasDoor()) {
                    new OuterMinecraftDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getMinecraft(), id, playerUUID);
                }
            } else {
                if (innerDisplayDoor.display()) {
                    new InnerDisplayDoorOpener(this.plugin).open(innerDisplayDoor.block(), id, true);
                } else {
                    new InnerMinecraftDoorOpener(this.plugin).open(innerDisplayDoor.block(), id);
                }
                if (outerDisplayDoor) {
                    new OuterDisplayDoorOpener(this.plugin).open(new OuterDoor(this.plugin, id).getDisplay(), id);
                } else if (rsp.getPreset().hasDoor()) {
                    new OuterMinecraftDoorOpener(this.plugin).open(new OuterDoor(this.plugin, id).getMinecraft(), id, player);
                }
            }
        }
    }
}

