/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.builders.exterior.EmergencyRelocation;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.data.Throticle;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetThrottle;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import me.eccentric_nz.TARDIS.utility.protection.TARDISLWCChecker;
import nl.rutgerkok.blocklocker.BlockLockerAPIv2;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ComehereCommand {
    private final TARDIS plugin;

    public ComehereCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void doComeHere(Player player) {
        if (TARDISPermission.hasPermission(player, "tardis.timetravel")) {
            UUID uuid = player.getUniqueId();
            if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(uuid.toString(), SystemTree.STATTENHEIM_REMOTE)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Stattenheim Remote");
                return;
            }
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", uuid.toString());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (!rs.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_A_TIMELORD");
                return;
            }
            if (!this.plugin.getConfig().getBoolean("difficulty.stattenheim_remote") || this.plugin.getUtils().inGracePeriod(player, true)) {
                int count;
                Tardis tardis = rs.getTardis();
                int id = tardis.getTardisId();
                if (this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
                    return;
                }
                int level = tardis.getArtronLevel();
                boolean hidden = tardis.isHidden();
                Location eyeLocation = player.getTargetBlock(this.plugin.getGeneralKeeper().getTransparent(), 50).getLocation();
                if (!this.plugin.getConfig().getBoolean("travel.include_default_world") && this.plugin.getConfig().getBoolean("creation.default_world") && eyeLocation.getWorld().getName().equals(this.plugin.getConfig().getString("creation.default_world_name"))) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_WORLD_TRAVEL");
                    return;
                }
                if (!this.plugin.getPluginRespect().getRespect(eyeLocation, new Parameters(player, Flag.getDefaultFlags()))) {
                    return;
                }
                if (TARDISPermission.hasPermission(player, "tardis.exile") && this.plugin.getConfig().getBoolean("travel.exile")) {
                    String areaPerm = this.plugin.getTardisArea().getExileArea(player);
                    if (this.plugin.getTardisArea().areaCheckInExile(areaPerm, eyeLocation)) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "EXILE_NO_TRAVEL");
                        return;
                    }
                }
                if (this.plugin.getTrackerKeeper().getDispersedTARDII().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NOT_WHILE_DISPERSED");
                    return;
                }
                if (this.plugin.getTardisArea().isInExistingArea(eyeLocation)) {
                    this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "AREA_NO_COMEHERE", "/tardistravel area [area name]", this.plugin);
                    return;
                }
                Material m = player.getTargetBlock(this.plugin.getGeneralKeeper().getTransparent(), 50).getType();
                if (m != Material.SNOW) {
                    int yplusone = eyeLocation.getBlockY();
                    eyeLocation.setY((double)(yplusone + 1));
                }
                String world = eyeLocation.getWorld().getName();
                if (!this.plugin.getPlanetsConfig().getBoolean("planets." + world + ".time_travel")) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PB_IN_WORLD");
                    return;
                }
                HashMap<String, Object> wherettrav = new HashMap<String, Object>();
                wherettrav.put("uuid", uuid.toString());
                wherettrav.put("tardis_id", id);
                ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wherettrav, false);
                if (rst.resultSet()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PB_IN_TARDIS");
                    return;
                }
                if (this.plugin.getTrackerKeeper().getInVortex().contains(id) || this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getDematerialising().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_MAT");
                    return;
                }
                ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                if (!rsc.resultSet()) {
                    new EmergencyRelocation(this.plugin).relocate(id, player);
                    return;
                }
                Current current = rsc.getCurrent();
                COMPASS d = current.direction();
                COMPASS player_d = COMPASS.valueOf(TARDISStaticUtils.getPlayersDirection(player, false));
                TARDISTimeTravel tt = new TARDISTimeTravel(this.plugin);
                boolean sub = false;
                Block b = eyeLocation.getBlock();
                if (b.getRelative(BlockFace.UP).getType().equals((Object)Material.WATER)) {
                    int n = count = tt.isSafeSubmarine(eyeLocation, player_d) ? 0 : 1;
                    if (count == 0) {
                        sub = true;
                    }
                } else {
                    int[] start_loc = TARDISTimeTravel.getStartLocation(eyeLocation, player_d);
                    count = TARDISTimeTravel.safeLocation(start_loc[0], eyeLocation.getBlockY(), start_loc[2], start_loc[1], start_loc[3], eyeLocation.getWorld(), player_d);
                }
                Block under = eyeLocation.getBlock().getRelative(BlockFace.DOWN);
                if (this.plugin.getPM().isPluginEnabled("BlockLocker") && (BlockLockerAPIv2.isProtected((Block)eyeLocation.getBlock()) || BlockLockerAPIv2.isProtected((Block)under))) {
                    count = 1;
                }
                if (this.plugin.getPM().isPluginEnabled("LWC") && new TARDISLWCChecker().isBlockProtected(eyeLocation.getBlock(), under, player)) {
                    count = 1;
                }
                if (count > 0) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WOULD_GRIEF_BLOCKS");
                    return;
                }
                Throticle throticle = new ResultSetThrottle(this.plugin).getSpeedAndParticles(uuid.toString());
                SpaceTimeThrottle spaceTimeThrottle = throticle.throttle();
                int ch = Math.round((float)this.plugin.getArtronConfig().getInt("comehere") * spaceTimeThrottle.getArtronMultiplier());
                if (level < ch) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ENOUGH_ENERGY");
                    return;
                }
                World w = current.location().getWorld();
                HashMap<String, Object> bid = new HashMap<String, Object>();
                bid.put("tardis_id", id);
                HashMap<String, Object> bset = new HashMap<String, Object>();
                if (w != null) {
                    bset.put("world", current.location().getWorld().getName());
                    bset.put("x", current.location().getBlockX());
                    bset.put("y", current.location().getBlockY());
                    bset.put("z", current.location().getBlockZ());
                    bset.put("direction", d.toString());
                    bset.put("submarine", current.submarine());
                } else {
                    hidden = true;
                    bset.put("world", eyeLocation.getWorld().getName());
                    bset.put("x", eyeLocation.getX());
                    bset.put("y", eyeLocation.getY());
                    bset.put("z", eyeLocation.getZ());
                    bset.put("submarine", sub ? 1 : 0);
                }
                this.plugin.getQueryFactory().doUpdate("back", bset, bid);
                HashMap<String, Object> tid = new HashMap<String, Object>();
                tid.put("tardis_id", id);
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("world", eyeLocation.getWorld().getName());
                set.put("x", eyeLocation.getBlockX());
                set.put("y", eyeLocation.getBlockY());
                set.put("z", eyeLocation.getBlockZ());
                set.put("direction", player_d.toString());
                set.put("submarine", sub ? 1 : 0);
                if (hidden) {
                    HashMap<String, Object> sett = new HashMap<String, Object>();
                    sett.put("hidden", 0);
                    HashMap<String, Object> ttid = new HashMap<String, Object>();
                    ttid.put("tardis_id", id);
                    this.plugin.getQueryFactory().doUpdate("tardis", sett, ttid);
                }
                this.plugin.getQueryFactory().doUpdate("current", set, tid);
                this.plugin.getMessenger().sendStatus(player, "TARDIS_COMING");
                long delay = 1L;
                this.plugin.getTrackerKeeper().getInVortex().add(id);
                boolean hid = hidden;
                if (!this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                    DestroyData dd = new DestroyData();
                    dd.setDirection(d);
                    dd.setLocation(current.location());
                    dd.setPlayer((OfflinePlayer)player);
                    dd.setHide(false);
                    dd.setOutside(true);
                    dd.setSubmarine(current.submarine());
                    dd.setTardisID(id);
                    dd.setThrottle(spaceTimeThrottle);
                    dd.setParticles(throticle.particles());
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        if (!hid) {
                            this.plugin.getTrackerKeeper().getDematerialising().add(id);
                            this.plugin.getPresetDestroyer().destroyPreset(dd);
                        } else {
                            this.plugin.getPresetDestroyer().removeBlockProtection(id);
                        }
                    }, delay);
                }
                BuildData bd = new BuildData(uuid.toString());
                bd.setDirection(player_d);
                bd.setLocation(eyeLocation);
                bd.setMalfunction(false);
                bd.setOutside(true);
                bd.setPlayer((OfflinePlayer)player);
                bd.setRebuild(false);
                bd.setSubmarine(sub);
                bd.setTardisID(id);
                bd.setThrottle(spaceTimeThrottle);
                bd.setParticles(throticle.particles());
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getPresetBuilder().buildPreset(bd), delay * 2L);
                HashMap<String, Object> wheret = new HashMap<String, Object>();
                wheret.put("tardis_id", id);
                this.plugin.getQueryFactory().alterEnergyLevel("tardis", -ch, wheret, player);
                this.plugin.getTrackerKeeper().getHasDestination().remove(id);
                this.plugin.getTrackerKeeper().getRescue().remove(id);
            } else {
                this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "DIFF_HARD_REMOTE", "/tardisrecipe remote", this.plugin);
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
        }
    }
}

