/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.HashMap;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TIPSData;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.ConsoleSize;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.schematic.SchematicBuilder;
import me.eccentric_nz.TARDIS.schematic.archive.ResultSetArchiveCount;
import me.eccentric_nz.TARDIS.schematic.archive.ResultSetArchiveName;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ArchiveUtility {
    private static Tardis getTardis(TARDIS plugin, String uuid) {
        Tardis tardis = null;
        HashMap<String, Object> wheret = new HashMap<String, Object>();
        wheret.put("uuid", uuid);
        ResultSetTravellers rst = new ResultSetTravellers(plugin, wheret, false);
        if (rst.resultSet()) {
            int id = rst.getTardis_id();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            where.put("uuid", uuid);
            ResultSetTardis rs = new ResultSetTardis(plugin, where, "", false);
            if (rs.resultSet()) {
                tardis = rs.getTardis();
            }
        }
        return tardis;
    }

    private static SchematicBuilder.ArchiveData getData(TARDIS plugin, Tardis tardis, String uuid, String name, String size, Player player) {
        int sz;
        int sx;
        int w;
        int h;
        Schematic current = tardis.getSchematic();
        ConsoleSize console_size = ConsoleSize.valueOf(size.toUpperCase(Locale.ROOT));
        int c = switch (console_size) {
            case ConsoleSize.MASSIVE -> {
                h = 31;
                w = 47;
                yield 47;
            }
            case ConsoleSize.WIDE -> {
                h = 15;
                w = 47;
                yield 47;
            }
            case ConsoleSize.TALL -> {
                h = 31;
                w = 31;
                yield 31;
            }
            case ConsoleSize.MEDIUM -> {
                h = 15;
                w = 31;
                yield 31;
            }
            default -> {
                h = 15;
                w = 15;
                yield 15;
            }
        };
        int slot = tardis.getTIPS();
        int id = tardis.getTardisId();
        if (slot != -1000001) {
            TARDISInteriorPostioning tintpos = new TARDISInteriorPostioning(plugin);
            TIPSData pos = tintpos.getTIPSData(slot);
            sx = pos.getCentreX();
            sz = pos.getCentreZ();
        } else {
            int[] gsl = plugin.getLocationUtils().getStartLocation(tardis.getTardisId());
            sx = gsl[0];
            sz = gsl[2];
        }
        int sy = current.getStartY();
        return new SchematicBuilder(plugin, id, player.getLocation().getWorld(), sx, sx + w, sy, sy + h, sz, sz + c, console_size).build();
    }

    public static void add(TARDIS plugin, Player player, String name, String size) {
        String uuid;
        ResultSetArchiveCount rsc;
        ResultSetArchiveName rsan = new ResultSetArchiveName(plugin, name);
        if (rsan.exists()) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_EXIST", name);
        }
        if ((rsc = new ResultSetArchiveCount(plugin, uuid = player.getUniqueId().toString())).count() >= plugin.getConfig().getInt("archive.limit")) {
            plugin.getMessenger().sendColouredCommand((CommandSender)player, "ARCHIVE_LIMIT", "/tardis archive update", plugin);
            return;
        }
        Tardis tardis = ArchiveUtility.getTardis(plugin, uuid);
        if (tardis == null) {
            return;
        }
        SchematicBuilder.ArchiveData ad = ArchiveUtility.getData(plugin, tardis, uuid, name, size, player);
        if (ad == null) {
            return;
        }
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("data", ad.getJSON().toString());
        set.put("console_size", ad.getSize().toString());
        set.put("beacon", ad.getBeacon());
        String lights = "TENTH";
        ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(plugin, uuid);
        if (rsp.resultSet()) {
            lights = rsp.getLights().toString();
        }
        set.put("lanterns", lights);
        set.put("uuid", uuid);
        set.put("name", name);
        set.put("y", ad.getStartY());
        plugin.getQueryFactory().doInsert("archive", set);
        plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_ADD", name);
    }

    public static void description(TARDIS plugin, Player player, String name, String description) {
        ResultSetArchiveName rsa = new ResultSetArchiveName(plugin, name);
        if (!rsa.exists()) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_NOT_EXIST", name);
            return;
        }
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("description", description);
        HashMap<String, Object> whereu = new HashMap<String, Object>();
        whereu.put("uuid", player.getUniqueId().toString());
        whereu.put("name", name);
        plugin.getQueryFactory().doUpdate("archive", set, whereu);
        plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_DESC", name);
    }

    public static void remove(TARDIS plugin, Player player, String name) {
        ResultSetArchiveName rsa = new ResultSetArchiveName(plugin, name);
        if (!rsa.exists()) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_NOT_EXIST", name);
            return;
        }
        HashMap<String, Object> whereu = new HashMap<String, Object>();
        whereu.put("uuid", player.getUniqueId().toString());
        whereu.put("name", name);
        plugin.getQueryFactory().doDelete("archive", whereu);
        plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_REMOVE", name);
    }

    public static void rename(TARDIS plugin, Player player, String name, String rename) {
        ResultSetArchiveName rsa = new ResultSetArchiveName(plugin, name);
        if (!rsa.exists()) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_NOT_EXIST", name);
            return;
        }
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("name", rename);
        HashMap<String, Object> whereu = new HashMap<String, Object>();
        whereu.put("uuid", player.getUniqueId().toString());
        whereu.put("name", name);
        plugin.getQueryFactory().doUpdate("archive", set, whereu);
        plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_RENAME", rename);
    }

    public static void scan(TARDIS plugin, Player player, String size) {
        String uuid = player.getUniqueId().toString();
        Tardis tardis = ArchiveUtility.getTardis(plugin, uuid);
        if (tardis == null) {
            return;
        }
        SchematicBuilder.ArchiveData ad = ArchiveUtility.getData(plugin, tardis, uuid, "", size, player);
        if (ad == null) {
            return;
        }
        plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_SCAN");
    }

    public static void update(TARDIS plugin, Player player, String name, String size) {
        ResultSetArchiveName rsa = new ResultSetArchiveName(plugin, name);
        if (!rsa.exists()) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_NOT_EXIST", name);
            return;
        }
        String uuid = player.getUniqueId().toString();
        Tardis tardis = ArchiveUtility.getTardis(plugin, uuid);
        if (tardis == null) {
            return;
        }
        SchematicBuilder.ArchiveData ad = ArchiveUtility.getData(plugin, tardis, uuid, "", size, player);
        if (ad == null) {
            return;
        }
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("data", ad.getJSON().toString());
        set.put("console_size", ad.getSize().toString());
        set.put("beacon", ad.getBeacon());
        String lights = "TENTH";
        ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(plugin, uuid);
        if (rsp.resultSet()) {
            lights = rsp.getLights().toString();
        }
        set.put("lanterns", lights);
        HashMap<String, Object> whereu = new HashMap<String, Object>();
        whereu.put("uuid", uuid);
        whereu.put("name", name);
        plugin.getQueryFactory().doUpdate("archive", set, whereu);
        plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_UPDATE", name);
    }

    public static void y(TARDIS plugin, Player player, String name, int y) {
        ResultSetArchiveName rsa = new ResultSetArchiveName(plugin, name);
        if (!rsa.exists()) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_NOT_EXIST", name);
            return;
        }
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("y", y);
        HashMap<String, Object> wherey = new HashMap<String, Object>();
        wherey.put("uuid", player.getUniqueId().toString());
        wherey.put("name", name);
        plugin.getQueryFactory().doUpdate("archive", set, wherey);
        plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCHIVE_UPDATE", name);
    }
}

