/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.achievement.TARDISAchievementFactory;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.companionGUI.CompanionAddInventory;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.Advancement;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AddCompanionCommand {
    private static final Pattern LETTERS_NUMBERS = Pattern.compile("[A-Za-z0-9_*.]{2,16}");
    private final TARDIS plugin;

    public AddCompanionCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void doAddGUI(Player player) {
        if (TARDISPermission.hasPermission(player, "tardis.add")) {
            player.openInventory(new CompanionAddInventory(this.plugin, player).getInventory());
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
        }
    }

    public void doAdd(Player player, String arg) {
        if (TARDISPermission.hasPermission(player, "tardis.add")) {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", player.getUniqueId().toString());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (!rs.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
                return;
            }
            Tardis tardis = rs.getTardis();
            int id = tardis.getTardisId();
            String comps = tardis.getCompanions();
            String data = tardis.getChunk();
            String owner = tardis.getOwner();
            if (!LETTERS_NUMBERS.matcher(arg).matches()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PLAYER_NOT_VALID");
            } else {
                World w;
                boolean addAll = arg.equalsIgnoreCase("everyone") || arg.equalsIgnoreCase("all");
                HashMap<String, Object> tid = new HashMap<String, Object>();
                HashMap<String, Object> set = new HashMap<String, Object>();
                OfflinePlayer companion = null;
                if (addAll) {
                    tid.put("tardis_id", id);
                    set.put("companions", "everyone");
                } else {
                    companion = Bukkit.getOfflinePlayer((String)arg);
                    if (companion.getName() != null) {
                        UUID oluuid = companion.getUniqueId();
                        tid.put("tardis_id", id);
                        if (comps != null && !comps.isEmpty() && !comps.equalsIgnoreCase("everyone")) {
                            String newList = comps + ":" + String.valueOf(oluuid);
                            set.put("companions", newList);
                        } else {
                            set.put("companions", oluuid.toString());
                        }
                        if (this.plugin.getAchievementConfig().getBoolean("friends.enabled")) {
                            TARDISAchievementFactory taf = new TARDISAchievementFactory(this.plugin, player, Advancement.FRIENDS, 1);
                            taf.doAchievement(1);
                        }
                    } else {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "COULD_NOT_FIND_NAME");
                        return;
                    }
                }
                if (this.plugin.isWorldGuardOnServer() && this.plugin.getConfig().getBoolean("preferences.use_worldguard") && (w = TARDISStaticLocationGetters.getWorldFromSplitString(data)) != null) {
                    if (addAll) {
                        this.plugin.getWorldGuardUtils().removeAllMembersFromRegion(w, player.getName(), player.getUniqueId());
                        this.plugin.getWorldGuardUtils().setEntryExitFlags(w.getName(), player.getName(), true);
                    } else {
                        this.plugin.getWorldGuardUtils().addMemberToRegion(w, owner, companion.getUniqueId());
                        this.plugin.getWorldGuardUtils().setEntryExitFlags(w.getName(), player.getName(), false);
                    }
                }
                this.plugin.getQueryFactory().doUpdate("tardis", set, tid);
                if (addAll) {
                    this.plugin.getMessenger().sendInsertedColour((CommandSender)player, "COMPANIONS_ADD", "everyone", this.plugin);
                    this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "COMPANIONS_EVERYONE", "/tardis remove all", this.plugin);
                } else {
                    this.plugin.getMessenger().sendInsertedColour((CommandSender)player, "COMPANIONS_ADD", arg, this.plugin);
                }
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
        }
    }
}

