/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.remote;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetBackLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BackCommand {
    private final TARDIS plugin;

    public BackCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void sendBack(CommandSender sender, int id, OfflinePlayer player) {
        HashMap<String, Object> wherebl = new HashMap<String, Object>();
        wherebl.put("tardis_id", id);
        ResultSetBackLocation rsb = new ResultSetBackLocation(this.plugin, wherebl);
        if (!rsb.resultSet()) {
            if (sender instanceof Player) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "PREV_NOT_FOUND");
            }
            return;
        }
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("world", rsb.getWorld().getName());
        set.put("x", rsb.getX());
        set.put("y", rsb.getY());
        set.put("z", rsb.getZ());
        set.put("direction", rsb.getDirection().toString());
        set.put("submarine", rsb.isSubmarine() ? 1 : 0);
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
        if (!rsc.resultSet()) {
            if (sender instanceof Player) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
            }
            return;
        }
        Current current = rsc.getCurrent();
        HashMap<String, Object> sett = new HashMap<String, Object>();
        sett.put("hidden", 0);
        HashMap<String, Object> ttid = new HashMap<String, Object>();
        ttid.put("tardis_id", id);
        this.plugin.getQueryFactory().doUpdate("tardis", sett, ttid);
        HashMap<String, Object> tid = new HashMap<String, Object>();
        tid.put("tardis_id", id);
        this.plugin.getQueryFactory().doUpdate("current", set, tid);
        this.plugin.getTrackerKeeper().getInVortex().add(id);
        if (!this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
            DestroyData dd = new DestroyData();
            dd.setDirection(current.direction());
            dd.setLocation(current.location());
            dd.setPlayer(player);
            dd.setHide(false);
            dd.setOutside(true);
            dd.setSubmarine(current.submarine());
            dd.setTardisID(id);
            dd.setThrottle(SpaceTimeThrottle.NORMAL);
            this.plugin.getTrackerKeeper().getDematerialising().add(id);
            this.plugin.getPresetDestroyer().destroyPreset(dd);
        }
        BuildData bd = new BuildData(player.getUniqueId().toString());
        bd.setDirection(rsb.getDirection());
        bd.setLocation(new Location(rsb.getWorld(), (double)rsb.getX(), (double)rsb.getY(), (double)rsb.getZ()));
        bd.setMalfunction(false);
        bd.setOutside(true);
        bd.setPlayer(player);
        bd.setRebuild(false);
        bd.setSubmarine(rsb.isSubmarine());
        bd.setTardisID(id);
        bd.setThrottle(SpaceTimeThrottle.NORMAL);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getPresetBuilder().buildPreset(bd), 20L);
        this.plugin.getTrackerKeeper().getHasDestination().remove(id);
        this.plugin.getTrackerKeeper().getRescue().remove(id);
    }
}

