/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.handles;

import java.util.Collections;
import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.data.Throticle;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoors;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetThrottle;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.flight.TARDISTakeoff;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.data.Openable;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TakeOffCommand {
    private final TARDIS plugin;

    public TakeOffCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void enterVortex(Player player, String uuid, int id) {
        HashMap<String, Object> wherei = new HashMap<String, Object>();
        wherei.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, wherei, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            if (tardis.getPreset().equals((Object)ChameleonPreset.JUNK)) {
                return;
            }
            if (this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn()) {
                this.plugin.getMessenger().handlesSend(player, "POWER_DOWN");
                return;
            }
            if (this.plugin.getTrackerKeeper().getInVortex().contains(id) || this.plugin.getTrackerKeeper().getDidDematToVortex().contains(id) || this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id) || this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getDematerialising().contains(id)) {
                this.plugin.getMessenger().handlesSend(player, "HANDBRAKE_IN_VORTEX");
                return;
            }
            HashMap<String, Object> whereh = new HashMap<String, Object>();
            whereh.put("type", 0);
            whereh.put("tardis_id", id);
            ResultSetControls rsc = new ResultSetControls(this.plugin, whereh, false);
            if (rsc.resultSet()) {
                if (tardis.isHandbrakeOn()) {
                    if (!this.plugin.getTrackerKeeper().getHasDestination().containsKey(id) && tardis.getArtronLevel() < this.plugin.getArtronConfig().getInt("random")) {
                        this.plugin.getMessenger().handlesSend(player, "ENERGY_NOT_ENOUGH");
                        return;
                    }
                    if (this.isDoorOpen(id)) {
                        this.plugin.getMessenger().handlesSend(player, "DOOR_CLOSE");
                        this.plugin.getTrackerKeeper().getHasClickedHandbrake().add(id);
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getTrackerKeeper().getHasClickedHandbrake().removeAll(Collections.singleton(id)), 600L);
                        return;
                    }
                    Location location = TARDISStaticLocationGetters.getLocationFromBukkitString(rsc.getLocation());
                    Block handbrake = location.getBlock();
                    ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid);
                    boolean beac_on = true;
                    boolean bar = false;
                    if (rsp.resultSet()) {
                        beac_on = rsp.isBeaconOn();
                        bar = rsp.isTravelbarOn();
                    }
                    Throticle throticle = new ResultSetThrottle(this.plugin).getSpeedAndParticles(uuid);
                    new TARDISTakeoff(this.plugin).run(id, handbrake, location, player, beac_on, tardis.getBeacon(), bar, throticle);
                } else {
                    this.plugin.getMessenger().handlesSend(player, "HANDBRAKE_OFF_ERR");
                }
            }
        }
    }

    private boolean isDoorOpen(int id) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        where.put("door_type", 1);
        ResultSetDoors rs = new ResultSetDoors(this.plugin, where, false);
        if (rs.resultSet()) {
            Openable door = (Openable)TARDISStaticLocationGetters.getLocationFromDB(rs.getDoor_location()).getBlock().getBlockData();
            return door.isOpen();
        }
        return false;
    }
}

