/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.handles;

import java.util.Collections;
import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.DamageUtility;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.artron.ArtronLevels;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.flight.TARDISHandbrake;
import me.eccentric_nz.TARDIS.flight.TARDISLand;
import me.eccentric_nz.TARDIS.sensor.BeaconSensor;
import me.eccentric_nz.TARDIS.travel.TARDISRandomiserCircuit;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class LandCommand {
    private final TARDIS plugin;

    public LandCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void exitVortex(Player player, int id, String uuid) {
        HashMap<String, Object> wherei = new HashMap<String, Object>();
        wherei.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, wherei, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            if (tardis.getPreset().equals((Object)ChameleonPreset.JUNK)) {
                this.plugin.getMessenger().handlesSend(player, "HANDLES_JUNK");
                return;
            }
            if (tardis.isHandbrakeOn()) {
                this.plugin.getMessenger().handlesSend(player, "HANDBRAKE_ON_ERR");
                return;
            }
            if (!this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                this.plugin.getMessenger().handlesSend(player, "HANDLES_VORTEX");
                return;
            }
            ResultSetCurrentFromId rscl = new ResultSetCurrentFromId(this.plugin, id);
            if (rscl.resultSet()) {
                Current current = rscl.getCurrent();
                Location l = new TARDISRandomiserCircuit(this.plugin).getRandomlocation(player, current.direction());
                if (l != null) {
                    HashMap<String, Object> set_next = new HashMap<String, Object>();
                    HashMap<String, Object> where_next = new HashMap<String, Object>();
                    set_next.put("world", l.getWorld().getName());
                    set_next.put("x", l.getBlockX());
                    set_next.put("y", l.getBlockY());
                    set_next.put("z", l.getBlockZ());
                    set_next.put("direction", current.direction().toString());
                    boolean sub = this.plugin.getTrackerKeeper().getSubmarine().contains(id);
                    set_next.put("submarine", sub ? 1 : 0);
                    this.plugin.getTrackerKeeper().getSubmarine().remove(id);
                    where_next.put("tardis_id", id);
                    this.plugin.getQueryFactory().doSyncUpdate("next", set_next, where_next);
                    this.plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(this.plugin.getArtronConfig().getInt("random_circuit"), TravelType.RANDOM));
                    this.plugin.getTrackerKeeper().getHasRandomised().add(id);
                    new TARDISLand(this.plugin, id, player).exitVortex();
                    this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.RANDOM, id));
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        HashMap<String, Object> whereh = new HashMap<String, Object>();
                        whereh.put("type", 0);
                        whereh.put("tardis_id", id);
                        whereh.put("secondary", 0);
                        ResultSetControls rsc = new ResultSetControls(this.plugin, whereh, false);
                        if (rsc.resultSet()) {
                            Location location = TARDISStaticLocationGetters.getLocationFromBukkitString(rsc.getLocation());
                            TARDISSounds.playTARDISSound(location, "tardis_handbrake_engage");
                            TARDISHandbrake.setLevers(location.getBlock(), true, true, location.toString(), id, this.plugin);
                            ArtronLevels tal = new ArtronLevels(this.plugin);
                            tal.recharge(id);
                            ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid);
                            boolean beac_on = true;
                            String beacon = tardis.getBeacon();
                            if (rsp.resultSet()) {
                                beac_on = rsp.isBeaconOn();
                            }
                            if (!beac_on && !beacon.isEmpty()) {
                                new BeaconSensor().toggle(beacon, false);
                            }
                            this.plugin.getMessenger().sendStatus(player, "HANDBRAKE_ON");
                            int amount = this.plugin.getTrackerKeeper().getHasDestination().get(id).cost() * -1;
                            HashMap<String, Object> wheret = new HashMap<String, Object>();
                            wheret.put("tardis_id", id);
                            this.plugin.getQueryFactory().alterEnergyLevel("tardis", amount, wheret, player);
                            this.plugin.getMessenger().sendArtron(player, id, Math.abs(amount));
                            this.plugin.getTrackerKeeper().getHasDestination().remove(id);
                            if (this.plugin.getTrackerKeeper().getHasRandomised().contains(id)) {
                                this.plugin.getTrackerKeeper().getHasRandomised().removeAll(Collections.singleton(id));
                            }
                            DamageUtility.run(this.plugin, DiskCircuit.MATERIALISATION, id, player);
                            HashMap<String, Object> set = new HashMap<String, Object>();
                            set.put("handbrake_on", 1);
                            HashMap<String, Object> whereb = new HashMap<String, Object>();
                            whereb.put("tardis_id", id);
                            this.plugin.getQueryFactory().doUpdate("tardis", set, whereb);
                        }
                    }, 400L);
                } else {
                    this.plugin.getMessenger().handlesSend(player, "HANDLES_NO_LOCATION");
                }
            } else {
                this.plugin.getMessenger().handlesSend(player, "CURRENT_NOT_FOUND");
            }
        }
    }
}

