/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.give.actions;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeUpdate;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SystemUpgrades {
    private final TARDIS plugin;

    public SystemUpgrades(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void give(CommandSender sender, Player player, String upgrade) {
        if (!this.plugin.getConfig().getBoolean("difficulty.system_upgrades")) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "SYS_DISABLED");
            return;
        }
        ResultSetTardisID rst = new ResultSetTardisID(this.plugin);
        String uuid = player.getUniqueId().toString();
        if (!rst.fromUUID(uuid)) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "PLAYER_NO_TARDIS");
            return;
        }
        if (upgrade.equalsIgnoreCase("all")) {
            for (SystemTree st : SystemTree.values()) {
                if (st.getSlot() == -1 || st == SystemTree.UPGRADE_TREE) continue;
                new SystemUpgradeUpdate(this.plugin).set(uuid, rst.getTardisId(), st);
            }
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "SYS_SUCCESS", "full TARDIS");
        } else {
            SystemTree systemTree;
            try {
                systemTree = SystemTree.valueOf(upgrade);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "SYS_INVALID");
                return;
            }
            new SystemUpgradeUpdate(this.plugin).set(uuid, rst.getTardisId(), systemTree);
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "SYS_SUCCESS", systemTree.getName());
        }
    }
}

