/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev.wiki;

import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.dev.wiki.PageBuilder;
import me.eccentric_nz.TARDIS.info.TARDISDescription;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;

public class ShapelessPageBuilder
extends PageBuilder {
    private final TARDIS plugin;

    public ShapelessPageBuilder(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    public void compile() {
        for (String key : this.plugin.getIncomposita().getShapelessRecipes().keySet()) {
            this.plugin.debug(key);
            String data = this.formatShapeless(key);
            if (data.isEmpty()) continue;
            this.save(TARDISStringUtils.toDashedLowercase(key), data);
        }
    }

    private String formatShapeless(String item) {
        String crafting = TARDISStringUtils.toLowercaseDashed(item);
        String easyIngredients = this.getIngredients(item);
        String easyTable = this.getShapelessTable(item);
        String desc = String.format("The %s is used to ", item);
        try {
            String info = TARDISStringUtils.toEnumUppercase(item) + "_INFO";
            TARDISDescription description = TARDISDescription.valueOf(info);
            desc = description.getDesc();
        }
        catch (IllegalArgumentException info) {
            // empty catch block
        }
        String SHAPELESS = "---\nlayout: default\ntitle: %s\n---\n\nimport Recipe from \"@site/src/components/Recipe\";\n\n%s\n===================\n\n%s\n\n## Crafting\n\n`/trecipe %s`\n\n| Ingredients | Crafting recipe |\n| ----------- | --------------- |\n| %s | <Recipe icons={%s} /> |\n";
        return String.format(SHAPELESS, item, item, desc, crafting, easyIngredients, easyTable);
    }

    private String getIngredients(String item) {
        StringBuilder ingredientBuilder = new StringBuilder();
        String prefix = "";
        for (RecipeChoice choice : this.plugin.getIncomposita().getShapelessRecipes().get(item).getChoiceList()) {
            String link = this.getLink(choice);
            ingredientBuilder.append(prefix);
            prefix = "<br/>";
            ingredientBuilder.append(link);
        }
        return ingredientBuilder.toString();
    }

    private String getShapelessTable(String item) {
        StringBuilder tableBuilder = new StringBuilder("[");
        String dashed = "";
        List shapeless = this.plugin.getIncomposita().getShapelessRecipes().get(item).getChoiceList();
        for (RecipeChoice choice : shapeless) {
            if (choice instanceof RecipeChoice.MaterialChoice) {
                RecipeChoice.MaterialChoice mat = (RecipeChoice.MaterialChoice)choice;
                dashed = TARDISStringUtils.toLowercaseDashed(TARDISStringUtils.capitalise(((Material)mat.getChoices().getFirst()).toString()));
            }
            if (choice instanceof RecipeChoice.ExactChoice) {
                RecipeChoice.ExactChoice exact = (RecipeChoice.ExactChoice)choice;
                ItemStack is = exact.getItemStack();
                switch (is.getType()) {
                    case POTION: {
                        PotionMeta pm = (PotionMeta)is.getItemMeta();
                        String potion = pm.getBasePotionType().name();
                        dashed = TARDISStringUtils.toLowercaseDashed("Potion of " + TARDISStringUtils.capitalise(potion));
                        break;
                    }
                    case ENCHANTED_BOOK: {
                        BookMeta bm = (BookMeta)is.getItemMeta();
                        String enchant = bm.getEnchants().keySet().stream().findFirst().toString();
                        String cap = TARDISStringUtils.capitalise(enchant);
                        dashed = TARDISStringUtils.toLowercaseDashed("Enchanted Book of " + cap);
                        break;
                    }
                    default: {
                        ItemMeta im = is.getItemMeta();
                        dashed = TARDISStringUtils.toLowercaseDashed(ComponentUtils.stripColour(im.displayName()));
                    }
                }
            }
            tableBuilder.append("'").append(dashed).append("'").append(",");
        }
        tableBuilder.append("'air',".repeat(Math.max(0, 9 - shapeless.size())));
        String result = TARDISStringUtils.toLowercaseDashed(item);
        tableBuilder.append("'").append(result).append("'").append("]");
        return tableBuilder.toString();
    }
}

