/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.SerializeInventory;
import me.eccentric_nz.TARDIS.custommodels.keys.CircuitVariant;
import me.eccentric_nz.TARDIS.enumeration.Storage;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class FixStorageCommand {
    private final TARDIS plugin;

    public FixStorageCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void convertStacks() {
        try {
            for (Storage storage : Storage.values()) {
                ItemStack[] stacks;
                for (ItemStack is : stacks = SerializeInventory.itemStacksFromString(storage.getEmpty())) {
                    ItemMeta im;
                    if (is == null || !is.hasItemMeta() || !(im = is.getItemMeta()).hasDisplayName()) continue;
                    Component component = im.displayName();
                    String stripped = ComponentUtils.stripColour(component);
                    if (!component.children().isEmpty()) {
                        stripped = ComponentUtils.stripColour((Component)component.children().getFirst());
                    }
                    im.displayName((Component)Component.text((String)stripped));
                    if (is.getType() == Material.GLOWSTONE_DUST) {
                        CustomModelDataComponent cmd = im.getCustomModelDataComponent();
                        cmd.setFloats(CircuitVariant.GALLIFREY.getFloats());
                        im.setCustomModelDataComponent(cmd);
                    }
                    im.setItemModel(null);
                    im.addItemFlags(ItemFlag.values());
                    im.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
                    is.setItemMeta(im);
                }
                String out = SerializeInventory.itemStacksToString(stacks);
                String file = String.valueOf(this.plugin.getDataFolder()) + File.separator + "storage_" + String.valueOf((Object)storage) + ".txt";
                try (BufferedWriter bw = new BufferedWriter(new FileWriter(file, false));){
                    bw.write(out);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

