/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev;

import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.ParticleData;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetParticlePrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetThrottle;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.particles.Emitter;
import me.eccentric_nz.TARDIS.particles.ParticleEffect;
import me.eccentric_nz.TARDIS.particles.ParticleShape;
import me.eccentric_nz.TARDIS.particles.Sphere;
import me.eccentric_nz.TARDIS.rooms.eye.Capacitor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class EffectCommand {
    private final TARDIS plugin;

    public EffectCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void show(Player player, String s, String e, int d, double v, String c, String b) {
        if (s.isEmpty()) {
            ResultSetCurrentFromId rsc;
            ResultSetTardisID rst = new ResultSetTardisID(this.plugin);
            UUID uuid = player.getUniqueId();
            if (rst.fromUUID(uuid.toString()) && (rsc = new ResultSetCurrentFromId(this.plugin, rst.getTardisId())).resultSet()) {
                ResultSetThrottle rs = new ResultSetThrottle(this.plugin);
                SpaceTimeThrottle throttle = rs.getSpeedAndParticles(uuid.toString()).throttle();
                ResultSetParticlePrefs rspp = new ResultSetParticlePrefs(this.plugin);
                if (rspp.fromUUID(uuid.toString())) {
                    ParticleData data = rspp.getData();
                    Emitter emitter = new Emitter(this.plugin, uuid, rsc.getCurrent().location().clone().add(0.5, 0.0, 0.5), data, throttle.getFlightTime());
                    int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)emitter, 0L, data.getShape().getPeriod());
                    emitter.setTaskID(task);
                }
            }
        } else if (s.equalsIgnoreCase("sphere")) {
            Location location = player.getLocation().add(3.5, 3.5, 3.5);
            Capacitor capacitor = Capacitor.valueOf(e.toUpperCase(Locale.ROOT));
            Sphere sphere = new Sphere(this.plugin, player.getUniqueId(), location, capacitor);
            int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)sphere, 0L, 10L);
            sphere.setTaskID(task);
        } else {
            ParticleEffect particle;
            ParticleShape shape;
            try {
                shape = ParticleShape.valueOf(s.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ex) {
                shape = ParticleShape.RANDOM;
            }
            try {
                particle = ParticleEffect.valueOf(e.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ex) {
                particle = ParticleEffect.EFFECT;
            }
            int density = 16;
            double speed = 0.0;
            String colour = "White";
            String block = "STONE";
            if (d > 0) {
                density = d;
            }
            if (v > 0.0) {
                speed = v;
            }
            if (!c.isEmpty()) {
                colour = c;
            }
            if (!b.isEmpty()) {
                block = b;
            }
            Emitter emitter = new Emitter(this.plugin, player.getUniqueId(), player.getLocation().add(3.0, 0.0, 3.0), new ParticleData(particle, shape, density, speed, colour, block, true), SpaceTimeThrottle.RAPID.getFlightTime());
            int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)emitter, 0L, shape.getPeriod());
            emitter.setTaskID(task);
        }
    }
}

