/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.bStats.ARSRoomCounts;
import me.eccentric_nz.TARDIS.blueprints.BlueprintRoom;
import me.eccentric_nz.TARDIS.customblocks.TARDISBlockDisplayItem;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetGames;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.move.TARDISTeleportLocation;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.tardisweepingangels.equip.MonsterArmour;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Art;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrushableBlock;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class DevelopmentUtility {
    public static void siege(TARDIS plugin, Player player) {
        ItemStack cube = player.getInventory().getItemInMainHand();
        ItemMeta im = cube.getItemMeta();
        im.getPersistentDataContainer().set(plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)TARDISBlockDisplayItem.SIEGE_CUBE.getCustomModel().getKey());
        ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
        lore.add(Component.text((String)"Time Lord: eccentric_nz"));
        lore.add(Component.text((String)"ID: 1"));
        im.lore(lore);
        cube.setItemMeta(im);
        plugin.getTrackerKeeper().getIsSiegeCube().add(1);
        plugin.getTrackerKeeper().getSiegeCarrying().put(player.getUniqueId(), 1);
    }

    public static void pong(TARDIS plugin, Player player) {
        ResultSetGames rsg;
        ResultSetTardisID rs = new ResultSetTardisID(plugin);
        if (rs.fromUUID(player.getUniqueId().toString()) && (rsg = new ResultSetGames(plugin)).fromId(rs.getTardisId())) {
            List<UUID> uuids = rsg.getPongUUIDs();
            for (Entity e : player.getLocation().getChunk().getEntities()) {
                if (!(e instanceof TextDisplay)) continue;
                TextDisplay display = (TextDisplay)e;
                plugin.debug(display.getUniqueId().toString());
                if (!uuids.contains(display.getUniqueId())) continue;
                plugin.debug("found!");
            }
        }
    }

    public static void pingPong(TARDIS plugin, Player player) {
        ResultSetGames rsg;
        ResultSetTardisID rs = new ResultSetTardisID(plugin);
        if (rs.fromUUID(player.getUniqueId().toString()) && rs.fromUUID(player.getUniqueId().toString()) && (rsg = new ResultSetGames(plugin)).fromId(rs.getTardisId())) {
            String playerLocation = rsg.getPlayerLocation();
            Location tp = TARDISStaticLocationGetters.getLocationFromBukkitString(playerLocation);
            tp.setYaw(180.0f);
            player.teleport(tp);
        }
    }

    public static void movePongDisplay(TARDIS plugin, Player player, double y) {
        ResultSetGames rsg;
        ResultSetTardisID rs = new ResultSetTardisID(plugin);
        if (rs.fromUUID(player.getUniqueId().toString()) && (rsg = new ResultSetGames(plugin)).fromId(rs.getTardisId())) {
            List<UUID> uuids = rsg.getPongUUIDs();
            for (UUID u : uuids) {
                Entity e = player.getWorld().getEntity(u);
                if (!(e instanceof TextDisplay)) continue;
                TextDisplay display = (TextDisplay)e;
                display.teleport(display.getLocation().add(0.0, y, 0.0));
            }
        }
    }

    public static void giveBlueprints(TARDIS plugin, Player player) {
        String uuid = player.getUniqueId().toString();
        for (BlueprintRoom bpr : BlueprintRoom.values()) {
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("uuid", uuid);
            set.put("permission", bpr.getPermission());
            plugin.getQueryFactory().doInsert("blueprint", set);
        }
    }

    public static void dalek(TARDIS plugin, Player player) {
        Location eyeLocation = player.getTargetBlock(null, 16).getLocation();
        eyeLocation.add(0.5, 1.25, 0.5);
        eyeLocation.setYaw(player.getLocation().getYaw() - 180.0f);
        Skeleton skeleton = (Skeleton)eyeLocation.getWorld().spawnEntity(eyeLocation, EntityType.SKELETON);
        EntityEquipment ee = skeleton.getEquipment();
        ItemStack head = ItemStack.of((Material)Material.SLIME_BALL);
        ItemMeta him = head.getItemMeta();
        him.setItemModel(new NamespacedKey((Plugin)plugin, "dalek_independent_head"));
        EquippableComponent component = him.getEquippable();
        component.setSlot(EquipmentSlot.HEAD);
        component.setAllowedEntities(EntityType.SKELETON);
        him.setEquippable(component);
        head.setItemMeta(him);
        ee.setHelmet(head);
        ItemStack body = ItemStack.of((Material)Material.SLIME_BALL);
        ItemMeta bim = body.getItemMeta();
        bim.setItemModel(new NamespacedKey((Plugin)plugin, "dalek_body"));
        body.setItemMeta(bim);
        ee.setItemInMainHand(body);
        PotionEffect invisibility = new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1, false, false);
        skeleton.addPotionEffect(invisibility);
        PotionEffect resistance = new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 360000, 3, false, false);
        skeleton.addPotionEffect(resistance);
    }

    public static void leather(Player player) {
        ItemStack is = ItemStack.of((Material)Material.LEATHER_HORSE_ARMOR);
        LeatherArmorMeta im = (LeatherArmorMeta)is.getItemMeta();
        im.setColor(Color.fromRGB((int)255, (int)0, (int)0));
        im.addItemFlags(ItemFlag.values());
        im.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
        im.setEquippable(null);
        CustomModelDataComponent cmdc = im.getCustomModelDataComponent();
        List<String> strings = List.of("chameleon_tint");
        cmdc.setStrings(strings);
        im.setCustomModelDataComponent(cmdc);
        is.setItemMeta((ItemMeta)im);
        player.getInventory().addItem(new ItemStack[]{is});
    }

    public static void listPortals(TARDIS plugin, Player player) {
        for (Map.Entry<Location, TARDISTeleportLocation> map : plugin.getTrackerKeeper().getPortals().entrySet()) {
            if (map.getKey().getWorld().getName().contains("TARDIS") || map.getValue().isAbandoned()) continue;
            plugin.getMessenger().message((CommandSender)player, "tardisId => " + map.getValue().getTardisId());
        }
        plugin.getMessenger().message((CommandSender)player, "End of open portal list.");
    }

    public static void listPaintings(TARDIS plugin) {
        Registry variants = RegistryAccess.registryAccess().getRegistry(RegistryKey.PAINTING_VARIANT);
        for (Art a : variants) {
            try {
                plugin.debug(String.valueOf(a) + " " + variants.getKey((Keyed)a).getKey());
            }
            catch (NoSuchMethodError | NullPointerException | NoSuchElementException throwable) {}
        }
    }

    public static void listStats(TARDIS plugin) {
        ARSRoomCounts arsRoomCounts = new ARSRoomCounts(plugin);
        for (Map.Entry<String, Integer> entry : arsRoomCounts.getRoomCounts().entrySet()) {
            plugin.debug(entry.getKey() + ": " + String.valueOf(entry.getValue()));
        }
        plugin.debug("Median per TARDIS: " + arsRoomCounts.getMedian());
    }

    public static void setArmour(Player player, String m, String s) {
        try {
            Monster monster = Monster.valueOf(m.toUpperCase(Locale.ROOT));
            EquipmentSlot slot = EquipmentSlot.valueOf((String)s.toUpperCase(Locale.ROOT));
            if (slot != EquipmentSlot.CHEST && slot != EquipmentSlot.LEGS) {
                return;
            }
            ItemStack a = MonsterArmour.makeEquippable(monster, slot);
            player.getInventory().addItem(new ItemStack[]{a});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void brush(Player player) {
        ItemStack sand = ItemStack.of((Material)Material.SUSPICIOUS_SAND);
        BlockStateMeta sandMeta = (BlockStateMeta)sand.getItemMeta();
        BrushableBlock blockState = (BrushableBlock)sandMeta.getBlockState();
        blockState.setItem(player.getInventory().getItemInMainHand());
        sandMeta.setBlockState((BlockState)blockState);
        sand.setItemMeta((ItemMeta)sandMeta);
        player.getInventory().addItem(new ItemStack[]{sand});
    }

    public static void chunky(TARDIS plugin, String world, String radius) {
        if (!plugin.getPM().isPluginEnabled("Chunky")) {
            plugin.getMessenger().message((CommandSender)plugin.getConsole(), TardisModule.WARNING, "Chunky plugin is not enabled!");
            return;
        }
        plugin.getServer().dispatchCommand((CommandSender)plugin.getConsole(), "chunky world " + world);
        plugin.getServer().dispatchCommand((CommandSender)plugin.getConsole(), "chunky radius " + radius);
        plugin.getServer().dispatchCommand((CommandSender)plugin.getConsole(), "chunky spawn");
        plugin.getServer().dispatchCommand((CommandSender)plugin.getConsole(), "chunky start");
        plugin.getServer().dispatchCommand((CommandSender)plugin.getConsole(), "chunky confirm");
    }
}

