/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev;

import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTransmat;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.desktop.PreviewData;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rooms.debug.DebugPopulator;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DebugCommand {
    private final TARDIS plugin;

    public DebugCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void process(CommandSender sender, String arg) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", player.getUniqueId().toString());
            ResultSetTravellers rs = new ResultSetTravellers(this.plugin, where, false);
            if (rs.resultSet()) {
                String param;
                switch (param = arg.toLowerCase(Locale.ROOT)) {
                    case "enter": {
                        this.enter(sender, rs.getTardis_id());
                        break;
                    }
                    case "exit": {
                        this.exit(sender);
                        break;
                    }
                    default: {
                        if (param.equals("create") || param.equals("update")) {
                            this.create(param.equals("update"));
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_IN_WORLD");
            }
        }
    }

    private void enter(CommandSender sender, int id) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            ResultSetTransmat rst = new ResultSetTransmat(this.plugin, -50, "debug_preview");
            if (rst.resultSet()) {
                Location transmat = rst.getLocation();
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT_DEBUG");
                transmat.setYaw(rst.getYaw());
                transmat.setPitch(player.getLocation().getPitch());
                this.plugin.getTrackerKeeper().getPreviewers().put(player.getUniqueId(), new PreviewData(player.getLocation().clone(), player.getGameMode(), id));
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    player.setGameMode(GameMode.ADVENTURE);
                    player.playSound(transmat, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
                    player.teleport(transmat);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PREVIEW_DEBUG");
                }, 10L);
            }
        }
    }

    private void exit(CommandSender sender) {
        if (sender instanceof Player) {
            Location transmat;
            Player player = (Player)sender;
            UUID uuid = player.getUniqueId();
            PreviewData data = this.plugin.getTrackerKeeper().getPreviewers().get(uuid);
            if (data != null && (transmat = data.location()) != null) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT");
                this.plugin.getTrackerKeeper().getPreviewers().remove(uuid);
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    player.playSound(transmat, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
                    player.teleport(transmat);
                    player.setGameMode(data.gamemode());
                }, 10L);
            }
        }
    }

    private void create(boolean update) {
        if (this.plugin.getConfig().getBoolean("creation.default_world")) {
            String dn = this.plugin.getConfig().getString("creation.default_world_name", "TARDIS_TimeVortex");
            World world = this.plugin.getServer().getWorld(dn);
            if (world != null) {
                DebugPopulator populator = new DebugPopulator(this.plugin, world);
                populator.createBase(update);
                populator.items();
                populator.blocks();
                populator.monsters();
                populator.chameleon();
                populator.doors();
                populator.rotors();
                populator.gui();
                populator.consoles();
                populator.chemistry();
                populator.sonicAndKeys();
                populator.regeneration();
                populator.handles();
                populator.lazarus();
                populator.setChests();
            }
        }
    }
}

