/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev;

import com.google.gson.JsonObject;
import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TIPSData;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.desktop.ChunkUtils;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.schematic.SchematicGZip;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChunksCommand {
    private final TARDIS plugin;

    public ChunksCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void list(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", player.getUniqueId().toString());
            ResultSetTravellers rs = new ResultSetTravellers(this.plugin, where, false);
            if (rs.resultSet()) {
                int id = rs.getTardis_id();
                HashMap<String, Object> wheret = new HashMap<String, Object>();
                wheret.put("tardis_id", id);
                ResultSetTardis rst = new ResultSetTardis(this.plugin, wheret, "", false);
                if (rst.resultSet()) {
                    Tardis tardis = rst.getTardis();
                    String[] tc = tardis.getChunk().split(":");
                    int cx = TARDISNumberParsers.parseInt(tc[1]);
                    int cz = TARDISNumberParsers.parseInt(tc[2]);
                    World world = player.getLocation().getWorld();
                    Chunk chunk = world.getChunkAt(cx, cz);
                    Schematic schematic = tardis.getSchematic();
                    for (Chunk c : ChunkUtils.getConsoleChunks(chunk, schematic)) {
                        this.plugin.debug(c);
                    }
                    this.plugin.debug("-----");
                    JsonObject obj = SchematicGZip.getObject(this.plugin, "consoles", schematic.getPermission(), schematic.isCustom());
                    if (obj != null) {
                        JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
                        int w = dimensions.get("width").getAsInt();
                        int d = dimensions.get("length").getAsInt() - 1;
                        Location location = this.getLocation(schematic, tardis, world);
                        for (Chunk c : ChunkUtils.getConsoleChunks(world, location.getChunk().getX(), location.getChunk().getZ(), w, d)) {
                            this.plugin.debug(c);
                        }
                    }
                }
            }
        }
    }

    private Location getLocation(Schematic schematic, Tardis tardis, World world) {
        TARDISInteriorPostioning tintpos = new TARDISInteriorPostioning(this.plugin);
        TIPSData pos = tintpos.getTIPSData(tardis.getTIPS());
        int startx = pos.getCentreX();
        int starty = schematic.getStartY();
        int startz = pos.getCentreZ();
        return new Location(world, (double)startx, (double)starty, (double)startz);
    }
}

