/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.config;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;

public class SetMaterialCommand {
    private final TARDIS plugin;

    public SetMaterialCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void setConfigMaterial(CommandSender sender, String option, String value, String section) {
        String first = section.isEmpty() ? option : section + "." + option;
        String setMaterial = value.toUpperCase(Locale.ROOT);
        if (this.checkMaterial(setMaterial)) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "MATERIAL_NOT_VALID");
        } else {
            this.plugin.getConfig().set(first, (Object)setMaterial);
            this.plugin.saveConfig();
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CONFIG_UPDATED", first);
        }
    }

    public void setConfigMaterial(CommandSender sender, String option, String value) {
        String first = option.toLowerCase(Locale.ROOT);
        String setMaterial = value.toUpperCase(Locale.ROOT);
        if (this.checkMaterial(setMaterial)) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "MATERIAL_NOT_VALID");
        } else {
            this.plugin.getArtronConfig().set(first, (Object)setMaterial);
            try {
                this.plugin.getArtronConfig().save(new File(this.plugin.getDataFolder(), "artron.yml"));
            }
            catch (IOException io) {
                this.plugin.debug("Could not save artron.yml, " + String.valueOf(io));
            }
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CONFIG_UPDATED", first);
        }
    }

    private boolean checkMaterial(String setMaterial) {
        try {
            Material.valueOf((String)setMaterial);
            return false;
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }
}

