/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.config;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.chameleon.shell.ShellLoaderListener;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.listeners.TARDISAntiBuildListener;
import me.eccentric_nz.TARDIS.listeners.TARDISZeroRoomChatListener;
import me.eccentric_nz.TARDIS.mapping.TARDISBlueMap;
import me.eccentric_nz.TARDIS.mapping.TARDISDynmap;
import me.eccentric_nz.TARDIS.mapping.TARDISMapper;
import me.eccentric_nz.TARDIS.planets.TARDISResourcePackSwitcher;
import me.eccentric_nz.TARDIS.rooms.eye.EyeStopper;
import org.bukkit.command.CommandSender;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;

public class SetBooleanCommand {
    private final TARDIS plugin;
    private final List<String> require_restart = List.of("use_default_condensables", "use_worldguard", "open_door_policy", "handles", "weather_set", "chemistry", "seed_block.crafting", "seed_block.legacy");
    private final List<String> register = List.of("wg_flag_set", "zero_room", "switch_resource_packs", "load_shells", "mapping");

    public SetBooleanCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void setConfigBool(CommandSender sender, String option, boolean bool, String section) {
        String first;
        String tolower = option.toLowerCase(Locale.ROOT);
        String string = first = section.isEmpty() ? tolower : section + "." + tolower;
        if (first.equals("switch_resource_packs")) {
            this.plugin.getPlanetsConfig().set("switch_resource_packs", (Object)bool);
            try {
                this.plugin.getPlanetsConfig().save(new File(this.plugin.getDataFolder(), "planets.yml"));
            }
            catch (IOException ex) {
                this.plugin.debug("Could not save planets.yml, " + ex.getMessage());
            }
        }
        if (first.equals("artron_furnace.furnace_particles")) {
            this.plugin.getArtronConfig().set("artron_furnace.particles", (Object)bool);
            try {
                this.plugin.getArtronConfig().save(new File(this.plugin.getDataFolder(), "artron.yml"));
            }
            catch (IOException ex) {
                this.plugin.debug("Could not save artron.yml, " + ex.getMessage());
            }
        } else {
            if ((first.equals("abandon") || first.equals("previews")) && bool && (this.plugin.getConfig().getBoolean("creation.create_worlds") || this.plugin.getConfig().getBoolean("creation.create_worlds_with_perms"))) {
                String which = first.equals("abandon") ? "Abandoned TARDISes" : "Desktop previews";
                this.plugin.getMessenger().messageWithColour(sender, which + " cannot be enabled as TARDISes are not stored in a TIPS world!", "#FF5555");
                return;
            }
            if (first.equals("archive") || first.equals("abandon")) {
                this.plugin.getConfig().set(first + ".enabled", (Object)bool);
            } else {
                this.plugin.getConfig().set(first, (Object)bool);
                if (first.equals("eye_of_harmony.particles") && !bool) {
                    new EyeStopper(this.plugin).kill();
                }
            }
            this.plugin.saveConfig();
        }
        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CONFIG_UPDATED", first);
        if (this.require_restart.contains(tolower)) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "RESTART");
        }
        if (this.register.contains(tolower)) {
            for (RegisteredListener rls : HandlerList.getRegisteredListeners((Plugin)this.plugin)) {
                switch (tolower) {
                    case "wg_flag_set": {
                        Listener listener = rls.getListener();
                        if (listener instanceof TARDISAntiBuildListener) {
                            TARDISAntiBuildListener anti = (TARDISAntiBuildListener)listener;
                            HandlerList.unregisterAll((Listener)anti);
                            break;
                        }
                        this.plugin.getPM().registerEvents((Listener)new TARDISAntiBuildListener(this.plugin), (Plugin)this.plugin);
                        break;
                    }
                    case "zero_room": {
                        Listener listener = rls.getListener();
                        if (listener instanceof TARDISZeroRoomChatListener) {
                            TARDISZeroRoomChatListener zero = (TARDISZeroRoomChatListener)listener;
                            HandlerList.unregisterAll((Listener)zero);
                            break;
                        }
                        this.plugin.getPM().registerEvents((Listener)new TARDISZeroRoomChatListener(this.plugin), (Plugin)this.plugin);
                        break;
                    }
                    case "switch_resource_packs": {
                        Listener listener = rls.getListener();
                        if (listener instanceof TARDISResourcePackSwitcher) {
                            TARDISResourcePackSwitcher pack = (TARDISResourcePackSwitcher)listener;
                            HandlerList.unregisterAll((Listener)pack);
                            break;
                        }
                        this.plugin.getPM().registerEvents((Listener)new TARDISResourcePackSwitcher(this.plugin), (Plugin)this.plugin);
                        break;
                    }
                    case "load_shells": {
                        Listener listener = rls.getListener();
                        if (listener instanceof ShellLoaderListener) {
                            ShellLoaderListener loader = (ShellLoaderListener)listener;
                            HandlerList.unregisterAll((Listener)loader);
                            break;
                        }
                        this.plugin.getPM().registerEvents((Listener)new ShellLoaderListener(this.plugin), (Plugin)this.plugin);
                        break;
                    }
                    case "mapping": {
                        if (this.plugin.getTardisMapper() == null) {
                            TARDISMapper tardisMapper = this.plugin.getConfig().getString("mapping.provider", "").equals("dynmap") ? new TARDISDynmap(this.plugin) : new TARDISBlueMap(this.plugin);
                            tardisMapper.enable();
                            this.plugin.setTardisMapper(tardisMapper);
                            break;
                        }
                        this.plugin.getTardisMapper().disable();
                        this.plugin.setTardisMapper(null);
                        break;
                    }
                }
            }
        }
    }
}

