/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.config;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.Config;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.TARDISWorlds;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;

public class ReloadCommand {
    private final TARDIS plugin;

    public ReloadCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void reloadConfig(CommandSender sender) {
        this.plugin.reloadConfig();
        TARDISWorlds tc = new TARDISWorlds(this.plugin);
        tc.doWorlds();
        this.plugin.saveConfig();
        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "RELOADED");
    }

    public void reloadOtherConfig(CommandSender sender, String module) {
        try {
            Config config = Config.valueOf(module.toLowerCase(Locale.ROOT));
            File file = new File(this.plugin.getDataFolder(), String.valueOf((Object)config) + ".yml");
            switch (config) {
                case achievements: {
                    this.plugin.getAchievementConfig().load(file);
                    break;
                }
                case adaptive: {
                    this.plugin.getAdaptiveConfig().load(file);
                    break;
                }
                case artron: {
                    this.plugin.getArtronConfig().load(file);
                    break;
                }
                case blaster: {
                    this.plugin.getBlasterConfig().load(file);
                    break;
                }
                case blocks: {
                    this.plugin.getBlocksConfig().load(file);
                    break;
                }
                case chameleon_guis: {
                    this.plugin.getChameleonGuis().load(new File(this.plugin.getDataFolder(), "language" + File.separator + "chameleon_guis.yml"));
                    break;
                }
                case condensables: {
                    this.plugin.getCondensablesConfig().load(file);
                    break;
                }
                case generator: {
                    this.plugin.getGeneratorConfig().load(file);
                    break;
                }
                case handles: {
                    this.plugin.getHandlesConfig().load(file);
                    break;
                }
                case items: {
                    this.plugin.getItemsConfig().load(file);
                    break;
                }
                case kits: {
                    this.plugin.getKitsConfig().load(file);
                    break;
                }
                case monsters: {
                    this.plugin.getMonstersConfig().load(file);
                    break;
                }
                case rooms: {
                    this.plugin.getRoomsConfig().load(file);
                    break;
                }
                case shop: {
                    this.plugin.getShopConfig().load(file);
                    break;
                }
                case signs: {
                    this.plugin.getSigns().load(new File(this.plugin.getDataFolder(), "language" + File.separator + "signs.yml"));
                    break;
                }
                case vortex_manipulator: {
                    this.plugin.getVortexConfig().load(file);
                    break;
                }
                default: {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "RELOAD_NOT_THESE", module);
                    return;
                }
            }
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "RELOAD_SUCCESS", config.toString());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "RELOAD_FILE_BAD", module);
        }
        catch (IOException | InvalidConfigurationException e) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "RELOAD_FAIL", module);
        }
    }
}

