/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.artron;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ArtronUtility {
    public static ItemStack hasCell(TARDIS plugin, Player player) {
        ItemStack is = player.getInventory().getItemInMainHand();
        if (!is.hasItemMeta()) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_IN_HAND");
            return null;
        }
        if (is.getAmount() > 1) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_ONE");
            return null;
        }
        ItemMeta im = is.getItemMeta();
        if (!im.hasDisplayName() || !ComponentUtils.endsWith(im.displayName(), "Artron Storage Cell")) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_IN_HAND");
            return null;
        }
        return is;
    }

    public static int getLevel(ItemMeta im) {
        String lore = ComponentUtils.stripColour((Component)im.lore().get(1));
        return TARDISNumberParsers.parseInt(lore);
    }

    public static void setLevel(ItemStack is, ItemMeta im, int level, Player player, boolean main) {
        List lore = im.lore();
        lore.set(1, Component.text((int)level));
        im.lore(lore);
        if (main && !im.hasEnchantmentGlintOverride()) {
            im.removeEnchant(Enchantment.UNBREAKING);
            im.setEnchantmentGlintOverride(Boolean.valueOf(true));
        }
        if (main) {
            is.setItemMeta(im);
            player.getInventory().setItemInMainHand(is);
        } else {
            if (level <= 0) {
                is.getEnchantments().keySet().forEach(arg_0 -> ((ItemStack)is).removeEnchantment(arg_0));
                im.setEnchantmentGlintOverride(null);
                is.setItemMeta(im);
            }
            player.getInventory().setItemInOffHand(is);
        }
    }

    public static void chargeCell(TARDIS plugin, ItemStack is, Player player, int amount, String table) {
        int max;
        int new_amount;
        ItemMeta im = is.getItemMeta();
        List lore = im.lore();
        int level = TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)lore.get(1)));
        if (level < 0) {
            level = 0;
        }
        if ((new_amount = amount + level) > (max = plugin.getArtronConfig().getInt("full_charge"))) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_NO_CHARGE", String.format("%d", max - level));
            return;
        }
        lore.set(1, Component.text((int)new_amount));
        im.lore(lore);
        im.setEnchantmentGlintOverride(Boolean.valueOf(true));
        im.addItemFlags(ItemFlag.values());
        im.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
        is.setItemMeta(im);
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", player.getUniqueId().toString());
        plugin.getQueryFactory().alterEnergyLevel(table, -amount, where, player);
        plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_CHARGED", String.format("%d", new_amount));
    }
}

