/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.areas;

import java.util.HashMap;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Area;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAreas;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AreaYard {
    public void create(TARDIS plugin, String name, String fill, String dock, Player player) {
        BlockData dockData;
        BlockData fillData;
        try {
            fillData = Material.valueOf((String)fill.toUpperCase(Locale.ROOT)).createBlockData();
            dockData = Material.valueOf((String)dock.toUpperCase(Locale.ROOT)).createBlockData();
        }
        catch (IllegalArgumentException e) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARG_MATERIAL");
            return;
        }
        if (!(fillData.getMaterial().isBlock() && dockData.getMaterial().isBlock() && fillData.getMaterial().isSolid() && dockData.getMaterial().isSolid())) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARG_NOT_BLOCK");
            return;
        }
        HashMap<String, Object> yardWhere = new HashMap<String, Object>();
        yardWhere.put("area_name", name);
        ResultSetAreas rsaYard = new ResultSetAreas(plugin, yardWhere, false, false);
        if (!rsaYard.resultSet()) {
            plugin.getMessenger().sendColouredCommand((CommandSender)player, "AREA_NOT_FOUND", "/tardis list areas", plugin);
            return;
        }
        Area yardArea = rsaYard.getArea();
        int yardMinX = yardArea.minX();
        int yardMinZ = yardArea.minZ();
        int yardMaxX = yardArea.maxX();
        int yardMaxZ = yardArea.maxZ();
        World yardWorld = TARDISAliasResolver.getWorldFromAlias(yardArea.world());
        for (int x = yardMinX; x <= yardMaxX; ++x) {
            for (int z = yardMinZ; z <= yardMaxZ; ++z) {
                int y = yardWorld.getHighestBlockYAt(x, z);
                if ((x - 2) % 5 == 0 && (z - 2) % 5 == 0) {
                    yardWorld.getBlockAt(x, y, z).setBlockData(dockData);
                    continue;
                }
                yardWorld.getBlockAt(x, y, z).setBlockData(fillData);
            }
        }
    }
}

