/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.admin;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TardisPagedLister {
    private final TARDIS plugin;
    private final CommandSender sender;

    public TardisPagedLister(TARDIS plugin, CommandSender sender) {
        this.plugin = plugin;
        this.sender = sender;
    }

    public void send(int page) {
        int start = page * 18 - 18;
        int end = page * 18;
        String limit = start + ", " + end;
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("abandoned", 0);
        ResultSetTardis rsl = new ResultSetTardis(this.plugin, where, limit, true);
        if (rsl.resultSet()) {
            this.plugin.getMessenger().send(this.sender, TardisModule.TARDIS, "TARDIS_LOCS");
            if (this.sender instanceof Player) {
                this.plugin.getMessenger().message(this.sender, "Hover to see location (world x, y, z)");
                this.plugin.getMessenger().message(this.sender, "Click to enter the TARDIS");
            }
            this.plugin.getMessenger().message(this.sender, "");
            for (Tardis tardis : rsl.getData()) {
                ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, tardis.getTardisId());
                if (!rsc.resultSet()) {
                    this.plugin.getMessenger().message(this.sender, TardisModule.TARDIS, Component.text((String)(tardis.getTardisId() + " "), (TextColor)NamedTextColor.GREEN).append((Component)Component.text((String)(tardis.getOwner() + " TARDIS is in an unloaded world!"), (TextColor)NamedTextColor.WHITE)));
                    continue;
                }
                Current current = rsc.getCurrent();
                String world = !this.plugin.getPlanetsConfig().getBoolean("planets." + current.location().getWorld().getName() + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE) ? this.plugin.getMVHelper().getAlias(current.location().getWorld()) : TARDISAliasResolver.getWorldAlias(current.location().getWorld());
                this.plugin.getMessenger().sendTARDISForList(this.sender, tardis, world, current.location().getBlockX(), current.location().getBlockY(), current.location().getBlockZ());
            }
            if (rsl.getData().size() > 18) {
                this.plugin.getMessenger().sendColouredCommand(this.sender, "TARDIS_LOCS_INFO", "/tardisadmin list 2", this.plugin);
            }
        } else {
            this.plugin.getMessenger().send(this.sender, TardisModule.TARDIS, "TARDIS_LOCS_NONE");
        }
    }
}

