/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.admin;

import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import org.bukkit.command.CommandSender;

public class RegionFlagCommand {
    private final TARDIS plugin;
    private final List<String> which = List.of("entry", "exit");

    public RegionFlagCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void toggleEntryExit(CommandSender sender, String flag) {
        if (!this.which.contains(flag)) {
            this.plugin.getMessenger().message(sender, "You need to specify which flag type you want to change to - entry or exit.");
            return;
        }
        if (!this.plugin.getConfig().getBoolean("creation.default_world")) {
            this.plugin.getMessenger().message(sender, "This command only works if you are using a default world for TARDISes.");
            return;
        }
        String world_name = this.plugin.getConfig().getString("creation.default_world_name");
        List<String> world_regions = this.plugin.getWorldGuardUtils().getTARDISRegions(TARDISAliasResolver.getWorldFromAlias(world_name));
        world_regions.forEach(region_id -> {
            if (flag.endsWith("entry")) {
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "rg flag " + region_id + " exit -w " + world_name);
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "rg flag " + region_id + " entry -w " + world_name + " -g nonmembers deny");
            } else {
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "rg flag " + region_id + " entry -w " + world_name);
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "rg flag " + region_id + " exit -w " + world_name + " -g everyone deny");
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "rg flag " + region_id + " use -w " + world_name + " allow");
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "rg flag " + region_id + " chest-access -w " + world_name);
            }
        });
    }
}

