/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.admin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.admin.AbandonedLister;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;

public class ListCommand {
    private final TARDIS plugin;

    public ListCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void listStuff(CommandSender sender, String what) {
        if (what.equalsIgnoreCase("save") || what.equalsIgnoreCase("portals") || what.equalsIgnoreCase("abandoned")) {
            if (what.equalsIgnoreCase("save")) {
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("abandoned", 1);
                ResultSetTardis rsl = new ResultSetTardis(this.plugin, where, "", true);
                if (rsl.resultSet()) {
                    String file = String.valueOf(this.plugin.getDataFolder()) + File.separator + "TARDIS_list.txt";
                    try (BufferedWriter bw = new BufferedWriter(new FileWriter(file, false));){
                        for (Tardis tardis : rsl.getData()) {
                            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, tardis.getTardisId());
                            if (!rsc.resultSet()) {
                                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                                return;
                            }
                            Current current = rsc.getCurrent();
                            String line = "ID: " + tardis.getTardisId() + ", Time Lord: " + tardis.getOwner() + ", Location: " + current.location().getWorld().getName() + ":" + current.location().getBlockX() + ":" + current.location().getBlockY() + ":" + current.location().getBlockZ();
                            bw.write(line);
                            bw.newLine();
                        }
                    }
                    catch (IOException e) {
                        this.plugin.debug("Could not create and write to TARDIS_list.txt! " + e.getMessage());
                    }
                }
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "FILE_SAVED");
            } else if (what.equalsIgnoreCase("portals")) {
                this.plugin.getTrackerKeeper().getPortals().forEach((key, value) -> sender.sendMessage("TARDIS id: " + value.getTardisId() + " has a portal open at: " + key.toString()));
            } else if (what.equalsIgnoreCase("abandoned")) {
                new AbandonedLister(this.plugin).list(sender);
            }
        }
    }
}

