/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.admin;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoors;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class EnterCommand {
    private final TARDIS plugin;

    public EnterCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void enterTARDIS(CommandSender sender, Player timelord) {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (player == null) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_PLAYER");
            return;
        }
        if (!TARDISPermission.hasPermission(player, "tardis.skeletonkey")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
            return;
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", timelord.getUniqueId().toString());
        where.put("abandoned", 0);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            int id = tardis.getTardisId();
            String owner = tardis.getOwner();
            this.process(player, owner, id);
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PLAYER_NO_TARDIS");
        }
    }

    public void enterTARDIS(CommandSender sender, int id) {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (player == null) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_PLAYER");
            return;
        }
        if (!TARDISPermission.hasPermission(player, "tardis.skeletonkey")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
            return;
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            String owner = tardis.getOwner();
            this.process(player, owner, id);
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ABANDONED_NOT_FOUND");
        }
    }

    private void process(Player player, String owner, int id) {
        HashMap<String, Object> wherei = new HashMap<String, Object>();
        wherei.put("door_type", 1);
        wherei.put("tardis_id", id);
        ResultSetDoors rsi = new ResultSetDoors(this.plugin, wherei, false);
        if (rsi.resultSet()) {
            COMPASS innerD = rsi.getDoor_direction();
            String doorLocStr = rsi.getDoor_location();
            World cw = TARDISStaticLocationGetters.getWorldFromSplitString(doorLocStr);
            Location tardis_loc = TARDISStaticLocationGetters.getLocationFromDB(doorLocStr);
            int getx = tardis_loc.getBlockX();
            int getz = tardis_loc.getBlockZ();
            switch (innerD) {
                case NORTH: {
                    tardis_loc.setX((double)getx + 0.5);
                    tardis_loc.setZ((double)getz - 0.5);
                    break;
                }
                case EAST: {
                    tardis_loc.setX((double)getx + 1.5);
                    tardis_loc.setZ((double)getz + 0.5);
                    break;
                }
                case SOUTH: {
                    tardis_loc.setX((double)getx + 0.5);
                    tardis_loc.setZ((double)getz + 1.5);
                    break;
                }
                default: {
                    tardis_loc.setX((double)getx - 0.5);
                    tardis_loc.setZ((double)getz + 0.5);
                }
            }
            if (this.plugin.isWorldGuardOnServer() && this.plugin.getConfig().getBoolean("preferences.use_worldguard")) {
                this.plugin.getWorldGuardUtils().addMemberToRegion(cw, owner, player.getUniqueId());
            }
            cw.getChunkAt(tardis_loc).load();
            float yaw = player.getLocation().getYaw();
            float pitch = player.getLocation().getPitch();
            tardis_loc.setPitch(pitch);
            COMPASS d = COMPASS.valueOf(TARDISStaticUtils.getPlayersDirection(player, false));
            if (!innerD.equals((Object)d)) {
                switch (d) {
                    case NORTH: {
                        yaw += this.plugin.getGeneralKeeper().getDoorListener().adjustYaw[0][innerD.ordinal() / 2];
                        break;
                    }
                    case WEST: {
                        yaw += this.plugin.getGeneralKeeper().getDoorListener().adjustYaw[1][innerD.ordinal() / 2];
                        break;
                    }
                    case SOUTH: {
                        yaw += this.plugin.getGeneralKeeper().getDoorListener().adjustYaw[2][innerD.ordinal() / 2];
                        break;
                    }
                    default: {
                        yaw += this.plugin.getGeneralKeeper().getDoorListener().adjustYaw[3][innerD.ordinal() / 2];
                    }
                }
            }
            tardis_loc.setYaw(yaw);
            World playerWorld = player.getLocation().getWorld();
            this.plugin.getGeneralKeeper().getDoorListener().movePlayer(player, tardis_loc, false, playerWorld, false, 3, true, false);
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("tardis_id", id);
            set.put("uuid", player.getUniqueId().toString());
            this.plugin.getQueryFactory().doInsert("travellers", set);
        }
    }
}

