/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.admin;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISDestructionEvent;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.destroyers.Exterminator;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.files.TARDISBlockLoader;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class DeleteTARDISCommand {
    private final TARDIS plugin;

    public DeleteTARDISCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public static void cleanDatabase(int id) {
        TARDISBlockLoader bl = new TARDISBlockLoader(TARDIS.plugin);
        bl.unloadProtectedBlocks(id);
        List<String> tables = List.of("ars", "back", "chunks", "controls", "current", "destinations", "doors", "gravity_well", "homes", "junk", "lamps", "next", "tardis", "thevoid", "travellers", "vaults");
        tables.forEach(table -> {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            TARDIS.plugin.getQueryFactory().doDelete((String)table, where);
        });
    }

    public void deleteTARDIS(CommandSender sender, Player player, int abandoned) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        UUID uuid = player.getUniqueId();
        where.put("uuid", uuid.toString());
        where.put("abandoned", abandoned);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            this.process(rs.getTardis(), sender, player);
        } else {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "PLAYER_NOT_FOUND_DB", player.getName());
        }
    }

    public void deleteTARDIS(CommandSender sender, int id, int abandoned) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        where.put("abandoned", abandoned);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            OfflinePlayer player = this.plugin.getServer().getOfflinePlayer(tardis.getUuid());
            this.process(tardis, sender, player.getPlayer());
        } else {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "PLAYER_NOT_FOUND_DB", "tardis_id=" + id);
        }
    }

    public void deleteJunk(CommandSender sender) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", "00000000-aaaa-bbbb-cccc-000000000000");
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            this.process(rs.getTardis(), sender, null);
        } else {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "PLAYER_NOT_FOUND_DB", "junk");
        }
    }

    private void process(Tardis tardis, CommandSender sender, Player player) {
        int id = tardis.getTardisId();
        int tips = tardis.getTIPS();
        Schematic schm = tardis.getSchematic();
        String chunkLoc = tardis.getChunk();
        boolean hidden = tardis.isHidden();
        String[] cdata = chunkLoc.split(":");
        String wname = cdata[0];
        World cw = TARDISAliasResolver.getWorldFromAlias(wname);
        if (cw == null) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "WORLD_DELETED");
            return;
        }
        Location bb_loc = null;
        COMPASS d = COMPASS.EAST;
        boolean sub = false;
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
        if (rsc.resultSet()) {
            Current current = rsc.getCurrent();
            bb_loc = current.location();
            d = current.direction();
            sub = current.submarine();
        }
        if (bb_loc == null) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
            return;
        }
        this.plugin.getPM().callEvent((Event)new TARDISDestructionEvent(player, bb_loc, tardis.getOwner()));
        if (!hidden) {
            UUID u = tardis.getUuid();
            DestroyData dd = new DestroyData();
            dd.setDirection(d);
            dd.setLocation(bb_loc);
            dd.setPlayer(this.plugin.getServer().getOfflinePlayer(u));
            dd.setHide(true);
            dd.setOutside(false);
            dd.setSubmarine(sub);
            dd.setTardisID(id);
            dd.setThrottle(SpaceTimeThrottle.REBUILD);
            this.plugin.getPresetDestroyer().destroyPreset(dd);
        }
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            if (this.plugin.getConfig().getBoolean("creation.create_worlds") && !this.plugin.getConfig().getBoolean("creation.default_world") || wname.contains("TARDIS_WORLD_")) {
                List players = cw.getPlayers();
                players.forEach(p -> p.kick((Component)Component.text((String)"World scheduled for deletion!")));
                if (!this.plugin.getPlanetsConfig().getBoolean("planets." + String.valueOf(cw) + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE)) {
                    this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "mv remove " + wname);
                }
                this.plugin.getServer().unloadWorld(cw, true);
                File world_folder = new File(String.valueOf(this.plugin.getServer().getWorldContainer()) + File.separator + wname + File.separator);
                if (!Exterminator.deleteFolder(world_folder)) {
                    this.plugin.debug("Could not delete world <" + wname + ">");
                }
            } else {
                this.plugin.getInteriorDestroyer().destroyInner(schm, id, cw, tips);
            }
            DeleteTARDISCommand.cleanDatabase(id);
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TARDIS_EXTERMINATED");
        }, 40L);
    }
}

