/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.admin;

import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.interior.TARDISBuildData;
import me.eccentric_nz.TARDIS.builders.utility.SeedBlockProcessor;
import me.eccentric_nz.TARDIS.enumeration.Desktops;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rooms.TARDISWalls;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CreateTARDISCommand {
    private final TARDIS plugin;
    private final String wall;
    private final String floor;

    public CreateTARDISCommand(TARDIS plugin, String wall, String floor) {
        this.plugin = plugin;
        this.wall = wall;
        this.floor = floor;
    }

    public void buildTARDIS(CommandSender sender, Player player, String seed) {
        if (sender instanceof Player) {
            Player admin = (Player)sender;
            if (!(!Desktops.getBY_NAMES().containsKey(seed) || seed.equals("SMALL") || seed.equals("MEDIUM") || seed.equals("TALL") || seed.equals("ARCHIVE"))) {
                Material floorMaterial;
                Material wallMaterial;
                Schematic schematic = Desktops.getBY_NAMES().get(seed);
                try {
                    wallMaterial = Material.valueOf((String)this.wall.toUpperCase(Locale.ROOT));
                    if (!TARDISWalls.BLOCKS.contains(wallMaterial)) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "WALL_NOT_VALID", this.wall);
                        TARDISWalls.BLOCKS.forEach(w -> sender.sendMessage(w.toString()));
                        return;
                    }
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "SEED_MAT_NOT_VALID", this.wall);
                    return;
                }
                try {
                    floorMaterial = Material.valueOf((String)this.floor);
                    if (!TARDISWalls.BLOCKS.contains(floorMaterial)) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "WALL_NOT_VALID", this.floor);
                        TARDISWalls.BLOCKS.forEach(w -> sender.sendMessage(w.toString()));
                        return;
                    }
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "SEED_MAT_NOT_VALID", this.floor);
                    return;
                }
                Location target = admin.getTargetBlock(this.plugin.getGeneralKeeper().getTransparent(), 16).getRelative(BlockFace.UP).getLocation();
                TARDISBuildData data = new TARDISBuildData();
                data.setSchematic(schematic);
                data.setWallType(wallMaterial);
                data.setFloorType(floorMaterial);
                new SeedBlockProcessor(this.plugin).processBlock(data, target, player);
            } else {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_SEED");
            }
        } else {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_PLAYER");
        }
    }
}

