/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.admin;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetChunkContainsTARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentLocation;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CleanEntitiesCommand {
    private final TARDIS plugin;

    public CleanEntitiesCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void checkAndRemove(CommandSender sender) {
        for (World world : this.plugin.getServer().getWorlds()) {
            int stands = 0;
            int interactions = 0;
            for (Entity entity : world.getEntities()) {
                Interaction interaction;
                ResultSetCurrentLocation rsc;
                HashMap<String, Object> where;
                ArmorStand stand;
                if (entity instanceof ArmorStand && (stand = (ArmorStand)entity).isInvisible() && stand.isInvulnerable()) {
                    where = new HashMap<String, Object>();
                    where.put("world", world.getName());
                    where.put("x", stand.getLocation().getBlockX());
                    where.put("y", stand.getLocation().getBlockY());
                    where.put("z", stand.getLocation().getBlockZ());
                    rsc = new ResultSetCurrentLocation(this.plugin, where);
                    if (rsc.resultSet()) {
                        this.plugin.getMessenger().message(sender, TardisModule.TARDIS, "Found a valid TARDIS armour stand, leaving as is!");
                        continue;
                    }
                    stand.remove();
                    ++stands;
                }
                if (!(entity instanceof Interaction) || !(interaction = (Interaction)entity).getPersistentDataContainer().has(this.plugin.getTardisIdKey(), PersistentDataType.INTEGER)) continue;
                where = new HashMap();
                where.put("world", world.getName());
                where.put("x", interaction.getLocation().getBlockX());
                where.put("y", interaction.getLocation().getBlockY());
                where.put("z", interaction.getLocation().getBlockZ());
                rsc = new ResultSetCurrentLocation(this.plugin, where);
                if (rsc.resultSet()) {
                    this.plugin.getMessenger().message(sender, TardisModule.TARDIS, "Found a valid TARDIS interaction, leaving as is!");
                    continue;
                }
                interaction.remove();
                ++interactions;
            }
            int forced = 0;
            for (Chunk chunk : world.getForceLoadedChunks()) {
                ResultSetChunkContainsTARDIS rsc = new ResultSetChunkContainsTARDIS(this.plugin, world.getName(), chunk.getX() * 16, chunk.getZ() * 16);
                if (rsc.resultSet()) continue;
                chunk.removePluginChunkTicket((Plugin)this.plugin);
                ++forced;
            }
            if (stands > 0) {
                this.plugin.getMessenger().message(sender, TardisModule.TARDIS, "Removed " + stands + " armour stands in " + world.getName());
            }
            if (interactions > 0) {
                this.plugin.getMessenger().message(sender, TardisModule.TARDIS, "Removed " + interactions + " interactions in " + world.getName());
            }
            if (forced <= 0) continue;
            this.plugin.getMessenger().message(sender, TardisModule.TARDIS, "Removed " + forced + " force loaded chunks in " + world.getName());
        }
    }
}

