/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.exterior.EmergencyRelocation;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.travel.ComehereRequest;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import me.eccentric_nz.TARDIS.utility.protection.TARDISLWCChecker;
import nl.rutgerkok.blocklocker.BlockLockerAPIv2;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TARDISCallRequestCommand {
    private final TARDIS plugin;

    public TARDISCallRequestCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void requestComeHere(Player player, Player requested) {
        int count;
        UUID uuid = requested.getUniqueId();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid.toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (!rs.resultSet()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PLAYER_NO_TARDIS");
            return;
        }
        Tardis tardis = rs.getTardis();
        int id = tardis.getTardisId();
        if (this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PLAYER_NOT_POWERED", requested.getName());
            return;
        }
        int level = tardis.getArtronLevel();
        Location eyeLocation = player.getTargetBlock(this.plugin.getGeneralKeeper().getTransparent(), 50).getLocation();
        if (!this.plugin.getConfig().getBoolean("travel.include_default_world") && this.plugin.getConfig().getBoolean("creation.default_world") && eyeLocation.getWorld().getName().equals(this.plugin.getConfig().getString("creation.default_world_name"))) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_WORLD_TRAVEL");
            return;
        }
        if (!this.plugin.getPluginRespect().getRespect(eyeLocation, new Parameters(player, Flag.getDefaultFlags()))) {
            return;
        }
        if (TARDISPermission.hasPermission(requested, "tardis.exile") && this.plugin.getConfig().getBoolean("travel.exile")) {
            String areaPerm = this.plugin.getTardisArea().getExileArea(requested);
            if (this.plugin.getTardisArea().areaCheckInExile(areaPerm, eyeLocation)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "EXILE_NO_REQUEST", requested.getName());
                return;
            }
        }
        if (this.plugin.getTrackerKeeper().getDispersedTARDII().contains(id)) {
            this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NOT_WHILE_DISPERSED_REQUEST", requested.getName());
            return;
        }
        if (this.plugin.getTardisArea().isInExistingArea(eyeLocation)) {
            this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "AREA_NO_COMEHERE", "/tardistravel area [area name]", this.plugin);
            return;
        }
        Material m = player.getTargetBlock(this.plugin.getGeneralKeeper().getTransparent(), 50).getType();
        if (m != Material.SNOW) {
            int yplusone = eyeLocation.getBlockY();
            eyeLocation.setY((double)(yplusone + 1));
        }
        String world = eyeLocation.getWorld().getName();
        if (!this.plugin.getPlanetsConfig().getBoolean("planets." + world + ".time_travel")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PB_IN_WORLD");
            return;
        }
        UUID playerUuid = player.getUniqueId();
        HashMap<String, Object> wherettrav = new HashMap<String, Object>();
        wherettrav.put("uuid", playerUuid.toString());
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wherettrav, false);
        if (rst.resultSet()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PB_IN_TARDIS");
            return;
        }
        HashMap<String, Object> wherein = new HashMap<String, Object>();
        wherein.put("uuid", uuid.toString());
        ResultSetTravellers rsti = new ResultSetTravellers(this.plugin, wherein, false);
        if (!rsti.resultSet()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PLAYER_NOT_IN_TARDIS", requested.getName());
            return;
        }
        if (this.plugin.getTrackerKeeper().getInVortex().contains(id) || this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getDematerialising().contains(id)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_MAT_REQUEST");
            return;
        }
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
        if (!rsc.resultSet()) {
            new EmergencyRelocation(this.plugin).relocate(id, player);
            return;
        }
        Current current = rsc.getCurrent();
        COMPASS d = current.direction();
        COMPASS player_d = COMPASS.valueOf(TARDISStaticUtils.getPlayersDirection(player, false));
        TARDISTimeTravel tt = new TARDISTimeTravel(this.plugin);
        boolean sub = false;
        Block b = eyeLocation.getBlock();
        if (b.getRelative(BlockFace.UP).getType().equals((Object)Material.WATER)) {
            int n = count = tt.isSafeSubmarine(eyeLocation, player_d) ? 0 : 1;
            if (count == 0) {
                sub = true;
            }
        } else {
            int[] start_loc = TARDISTimeTravel.getStartLocation(eyeLocation, player_d);
            count = TARDISTimeTravel.safeLocation(start_loc[0], eyeLocation.getBlockY(), start_loc[2], start_loc[1], start_loc[3], eyeLocation.getWorld(), player_d);
        }
        Block under = eyeLocation.getBlock().getRelative(BlockFace.DOWN);
        if (this.plugin.getPM().isPluginEnabled("BlockLocker") && (BlockLockerAPIv2.isProtected((Block)eyeLocation.getBlock()) || BlockLockerAPIv2.isProtected((Block)under))) {
            count = 1;
        }
        if (this.plugin.getPM().isPluginEnabled("LWC") && new TARDISLWCChecker().isBlockProtected(eyeLocation.getBlock(), under, player)) {
            count = 1;
        }
        if (count > 0) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WOULD_GRIEF_BLOCKS");
            return;
        }
        ComehereRequest request = new ComehereRequest();
        request.setRequester(playerUuid);
        request.setAccepter(uuid);
        request.setId(id);
        request.setLevel(level);
        request.setCurrent(current.location());
        request.setCurrentDirection(d);
        request.setDestination(eyeLocation);
        request.setDestinationDirection(player_d);
        request.setSubmarine(sub);
        request.setHidden(tardis.isHidden());
        this.plugin.getTrackerKeeper().getComehereRequests().put(uuid, request);
        this.plugin.getMessenger().send((CommandSender)requested, TardisModule.TARDIS, "REQUEST_COMEHERE", player.getName());
        this.plugin.getMessenger().sendRequestComehereAccept((CommandSender)requested, "REQUEST_COMEHERE_ACCEPT", "/tardis call accept");
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "REQUEST_SENT", requested.getName());
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            if (this.plugin.getTrackerKeeper().getComehereRequests().containsKey(playerUuid)) {
                this.plugin.getTrackerKeeper().getComehereRequests().remove(playerUuid);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "REQUEST_NO_RESPONSE", requested.getName());
            }
        }, 1200L);
    }
}

