/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.files.TARDISRoomMap;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RoomsUtility {
    public static void add(TARDIS plugin, CommandSender sender, String name) {
        Pattern regex = Pattern.compile(".*[A-Z].*");
        if (regex.matcher(name).matches()) {
            plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_LOWERCASE");
            return;
        }
        if (name.equals("ADD") || name.equals("BLOCKS")) {
            plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_NO_NAME", name);
            return;
        }
        if (plugin.getRoomsConfig().contains("rooms." + name)) {
            plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_EXISTS");
            return;
        }
        String lower = name.toLowerCase(Locale.ROOT);
        String filepath = String.valueOf(plugin.getDataFolder()) + File.separator + "user_schematics" + File.separator + lower + ".tschm";
        File file = new File(filepath);
        if (!file.exists()) {
            plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_SCHEMATIC_INFO", lower);
            return;
        }
        boolean success = new TARDISRoomMap(plugin).makeRoomMap(lower, name, true);
        if (!success) {
            plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_FAILED");
            return;
        }
        plugin.getRoomsConfig().set("rooms." + name + ".enabled", (Object)false);
        plugin.getRoomsConfig().set("rooms." + name + ".user", (Object)true);
        try {
            plugin.getRoomsConfig().save(new File(plugin.getDataFolder(), "rooms.yml"));
        }
        catch (IOException io) {
            plugin.debug("Could not save rooms.yml, " + String.valueOf(io));
        }
        plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_ADDED");
    }

    public static void listBlocks(TARDIS plugin, CommandSender sender, String name) {
        ResultSetPlayerPrefs rsp;
        HashMap<String, Integer> blockIDs = plugin.getBuildKeeper().getRoomBlockCounts().get(name);
        boolean hasPrefs = false;
        String wall = "ORANGE WOOL";
        String floor = "LIGHT GREY WOOL";
        if (sender instanceof Player && (rsp = new ResultSetPlayerPrefs(plugin, ((Player)sender).getUniqueId().toString())).resultSet()) {
            hasPrefs = true;
            wall = rsp.getWall();
            floor = rsp.getFloor();
        }
        plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_BLOCKS", name);
        for (Map.Entry<String, Integer> entry : blockIDs.entrySet()) {
            String mat = hasPrefs && (entry.getKey().equals("ORANGE_WOOL") || entry.getKey().equals("LIGHT_GRAY_WOOL")) ? (entry.getKey().equals("ORANGE_WOOL") ? wall : floor) : entry.getKey();
            int tmp = Math.round((float)entry.getValue().intValue() / 100.0f * (float)plugin.getConfig().getInt("growth.rooms_condenser_percent"));
            int amount = tmp > 0 ? tmp : 1;
            String line = mat + ", " + amount;
            sender.sendMessage(line);
        }
    }

    public static void saveBlocks(TARDIS plugin, CommandSender sender) {
        plugin.getRoomsConfig().getConfigurationSection("rooms").getKeys(false).forEach(r -> {
            if (plugin.getRoomsConfig().getBoolean("rooms." + r + ".enabled")) {
                HashMap<String, Integer> blockIDs = plugin.getBuildKeeper().getRoomBlockCounts().get(r);
                String file = String.valueOf(plugin.getDataFolder()) + File.separator + r + "_block_list.txt";
                int cost = 0;
                try (BufferedWriter bw = new BufferedWriter(new FileWriter(file, false));){
                    for (Map.Entry<String, Integer> entry : blockIDs.entrySet()) {
                        String line = entry.getKey() + ", " + String.valueOf(entry.getValue());
                        bw.write(line);
                        bw.newLine();
                        if (!plugin.getCondensables().containsKey(entry.getKey())) continue;
                        int value = entry.getValue() * plugin.getCondensables().get(entry.getKey());
                        cost += value;
                    }
                    int artron_cost = Math.round((float)cost / 2.0f);
                    float tmp_cost = (float)artron_cost / 10.0f;
                    int config_cost = (int)tmp_cost / 25 * 25;
                    bw.write("Actual room cost: " + artron_cost);
                    bw.newLine();
                    bw.write("Config room cost: " + config_cost);
                    bw.newLine();
                }
                catch (IOException e) {
                    plugin.debug("Could not create and write to " + r + "_block_list.txt! " + e.getMessage());
                }
                plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_FILE_SAVED", r);
            }
        });
    }

    public static void setRoomEnabled(TARDIS plugin, CommandSender sender, String room, boolean bool) {
        plugin.getRoomsConfig().set("rooms." + room + ".enabled", (Object)bool);
        try {
            plugin.getRoomsConfig().save(new File(plugin.getDataFolder(), "rooms.yml"));
            if (bool) {
                plugin.getGeneralKeeper().getRoomArgs().add(room);
            } else {
                plugin.getGeneralKeeper().getRoomArgs().remove(room);
            }
            plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_TRUE_FALSE", room, Boolean.toString(bool));
        }
        catch (IOException io) {
            plugin.debug("Could not save rooms.yml, " + String.valueOf(io));
        }
    }

    public static void setRoomSeed(TARDIS plugin, CommandSender sender, String room, String material) {
        try {
            Material.valueOf((String)material);
        }
        catch (IllegalArgumentException e) {
            plugin.getMessenger().send(sender, TardisModule.TARDIS, "MATERIAL_NOT_VALID");
            return;
        }
        for (String m : plugin.getRoomsConfig().getConfigurationSection("rooms").getKeys(false)) {
            if (!material.equalsIgnoreCase(plugin.getRoomsConfig().getString("rooms." + m + ".seed"))) continue;
            plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_SEED_EXISTS");
            return;
        }
        plugin.getRoomsConfig().set("rooms." + room + ".seed", (Object)material);
        try {
            plugin.getRoomsConfig().save(new File(plugin.getDataFolder(), "rooms.yml"));
            plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_SEED_SET", room, material);
        }
        catch (IOException io) {
            plugin.debug("Could not save rooms.yml, " + String.valueOf(io));
        }
        Material m = Material.valueOf((String)material);
        plugin.getBuildKeeper().getRoomSeeds().put(m, room);
    }
}

