/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands;

import java.util.HashMap;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.RecipeCategory;
import me.eccentric_nz.TARDIS.enumeration.RecipeItem;
import me.eccentric_nz.TARDIS.recipes.TARDISShowSeedRecipeInventory;
import me.eccentric_nz.TARDIS.recipes.TARDISShowShapedRecipeInventory;
import me.eccentric_nz.TARDIS.recipes.TARDISShowShapelessRecipeInventory;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class RecipeUtility {
    private static final HashMap<String, String> RECIPE_ITEMS = new HashMap<String, String>(){
        {
            for (RecipeItem recipeItem : RecipeItem.values()) {
                if (recipeItem.getCategory() == RecipeCategory.UNCRAFTABLE || recipeItem.getCategory() == RecipeCategory.UNUSED) continue;
                this.put(recipeItem.toTabCompletionString(), recipeItem.toRecipeString());
            }
            for (String r : TARDIS.plugin.getCustomRotorsConfig().getKeys(false)) {
                this.put("time-rotor-" + r.toLowerCase(Locale.ROOT), "Time Rotor " + TARDISStringUtils.capitalise(r));
            }
            for (String d : TARDIS.plugin.getCustomDoorsConfig().getKeys(false)) {
                this.put("door-" + d.toLowerCase(Locale.ROOT), "Door " + TARDISStringUtils.capitalise(d));
            }
            for (String c : TARDIS.plugin.getCustomConsolesConfig().getConfigurationSection("consoles").getKeys(false)) {
                this.put("console-" + c.toLowerCase(Locale.ROOT), TARDISStringUtils.capitalise(c) + " Console");
            }
            if (!TARDIS.plugin.getConfig().getBoolean("modules.vortex_manipulator")) {
                this.remove("vortex-manipulator");
            }
            if (!TARDIS.plugin.getConfig().getBoolean("modules.regeneration")) {
                this.remove("elixir-of-life");
            }
            if (!TARDIS.plugin.getConfig().getBoolean("modules.sonic_blaster")) {
                this.remove("sonic-blaster");
                this.remove("blaster-battery");
                this.remove("landing-pad");
            }
            if (!TARDIS.plugin.getConfig().getBoolean("modules.weeping_angels")) {
                this.remove("judoon-ammunition");
                this.remove("k9");
            }
        }
    };
    private static final HashMap<String, Material> TYPES = new HashMap<String, Material>(){
        {
            this.put("ANCIENT", Material.SCULK);
            this.put("ARS", Material.QUARTZ_BLOCK);
            this.put("BIGGER", Material.GOLD_BLOCK);
            this.put("BONE", Material.WAXED_OXIDIZED_CUT_COPPER);
            this.put("BUDGET", Material.IRON_BLOCK);
            this.put("CAVE", Material.DRIPSTONE_BLOCK);
            this.put("COPPER", Material.WARPED_PLANKS);
            this.put("CORAL", Material.NETHER_WART_BLOCK);
            this.put("CURSED", Material.BLACK_CONCRETE);
            this.put("DELTA", Material.CRYING_OBSIDIAN);
            this.put("DELUXE", Material.DIAMOND_BLOCK);
            this.put("DINER", Material.STRIPPED_CRIMSON_HYPHAE);
            this.put("DIVISION", Material.PINK_GLAZED_TERRACOTTA);
            this.put("EIGHTH", Material.CHISELED_STONE_BRICKS);
            this.put("ELEVENTH", Material.EMERALD_BLOCK);
            this.put("ENDER", Material.PURPUR_BLOCK);
            this.put("FACTORY", Material.YELLOW_CONCRETE_POWDER);
            this.put("FIFTEENTH", Material.OCHRE_FROGLIGHT);
            this.put("FUGITIVE", Material.POLISHED_DEEPSLATE);
            this.put("HELL_BENT", Material.WHITE_GLAZED_TERRACOTTA);
            this.put("HOSPITAL", Material.WHITE_CONCRETE);
            this.put("MASTER", Material.NETHER_BRICKS);
            this.put("MECHANICAL", Material.POLISHED_ANDESITE);
            this.put("ORIGINAL", Material.PACKED_MUD);
            this.put("PLANK", Material.BOOKSHELF);
            this.put("PYRAMID", Material.SANDSTONE_STAIRS);
            this.put("REDSTONE", Material.REDSTONE_BLOCK);
            this.put("ROTOR", Material.HONEYCOMB_BLOCK);
            this.put("RUSTIC", Material.COPPER_BULB);
            this.put("SIDRAT", Material.GREEN_CONCRETE);
            this.put("STEAMPUNK", Material.COAL_BLOCK);
            this.put("THIRTEENTH", Material.ORANGE_CONCRETE);
            this.put("TOM", Material.LAPIS_BLOCK);
            this.put("TWELFTH", Material.PRISMARINE);
            this.put("WAR", Material.WHITE_TERRACOTTA);
            this.put("WEATHERED", Material.WEATHERED_COPPER);
            this.put("LEGACY_BIGGER", Material.ORANGE_GLAZED_TERRACOTTA);
            this.put("LEGACY_DELUXE", Material.LIME_GLAZED_TERRACOTTA);
            this.put("LEGACY_ELEVENTH", Material.CYAN_GLAZED_TERRACOTTA);
            this.put("LEGACY_REDSTONE", Material.RED_GLAZED_TERRACOTTA);
        }
    };

    public static void showTARDISRecipe(TARDIS plugin, Player player, String type) {
        player.closeInventory();
        plugin.getTrackerKeeper().getRecipeViewers().add(player.getUniqueId());
        player.openInventory(new TARDISShowSeedRecipeInventory(plugin, type, TYPES.get(type)).getInventory());
    }

    public static void showItemRecipe(TARDIS plugin, Player player, String item) {
        switch (item) {
            case "bowl-of-custard": 
            case "jelly-baby": 
            case "biome-storage-disk": 
            case "player-storage-disk": 
            case "preset-storage-disk": 
            case "save-storage-disk": 
            case "schematic-wand": 
            case "admin-upgrade": 
            case "bio-scanner-upgrade": 
            case "redstone-upgrade": 
            case "diamond-upgrade": 
            case "emerald-upgrade": 
            case "painter-upgrade": 
            case "ignite-upgrade": 
            case "pickup-arrows-upgrade": 
            case "knockback-upgrade": 
            case "brush-upgrade": 
            case "judoon-ammunition": {
                RecipeUtility.showShapelessRecipe(plugin, player, RECIPE_ITEMS.get(item));
                break;
            }
            default: {
                RecipeUtility.showShapedRecipe(plugin, player, RECIPE_ITEMS.get(item));
            }
        }
    }

    private static void showShapedRecipe(TARDIS plugin, Player player, String str) {
        ShapedRecipe recipe = plugin.getFigura().getShapedRecipes().get(str);
        if (recipe == null) {
            plugin.debug(str);
        } else {
            player.discoverRecipe(recipe.getKey());
            player.closeInventory();
            plugin.getTrackerKeeper().getRecipeViewers().add(player.getUniqueId());
            player.openInventory(new TARDISShowShapedRecipeInventory(plugin, recipe, str).getInventory());
        }
    }

    private static void showShapelessRecipe(TARDIS plugin, Player player, String str) {
        ShapelessRecipe recipe = plugin.getIncomposita().getShapelessRecipes().get(str);
        player.discoverRecipe(recipe.getKey());
        player.closeInventory();
        plugin.getTrackerKeeper().getRecipeViewers().add(player.getUniqueId());
        player.openInventory(new TARDISShowShapelessRecipeInventory(plugin, recipe, str).getInventory());
    }
}

