/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands;

import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class GravityUtility {
    private final TARDIS plugin;
    private final HashMap<String, Double> gravityDirection = new HashMap();

    public GravityUtility(TARDIS plugin) {
        this.plugin = plugin;
        this.gravityDirection.put("down", 0.0);
        this.gravityDirection.put("up", 1.0);
        this.gravityDirection.put("north", 2.0);
        this.gravityDirection.put("west", 3.0);
        this.gravityDirection.put("south", 4.0);
        this.gravityDirection.put("east", 5.0);
    }

    public void make(Player player, String direction, double distance, double velocity) {
        if (!this.plugin.getConfig().getBoolean("allow.external_gravity") && !this.plugin.getUtils().inTARDISWorld(player)) {
            String mess_stub = player.getLocation().getWorld().getName().toUpperCase(Locale.ROOT).contains("TARDIS_WORLD_") ? "GRAVITY_OWN_WORLD" : "GRAVITY_A_WORLD";
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, mess_stub);
            return;
        }
        if (velocity > this.plugin.getConfig().getDouble("growth.gravity_max_velocity")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "GRAVITY_FAST");
            return;
        }
        UUID uuid = player.getUniqueId();
        this.plugin.getTrackerKeeper().getGravity().put(uuid, new Double[]{this.gravityDirection.get(direction), distance, velocity});
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "GRAVITY_CLICK_SAVE");
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getTrackerKeeper().getGravity().remove(uuid), 1200L);
    }

    public void remove(Player player) {
        UUID uuid = player.getUniqueId();
        this.plugin.getTrackerKeeper().getGravity().put(uuid, new Double[]{6.0});
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "GRAVITY_CLICK_REMOVE");
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getTrackerKeeper().getGravity().remove(uuid), 1200L);
    }
}

