/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.chameleon.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.chameleon.TARDISChameleonPreset;
import me.eccentric_nz.TARDIS.chameleon.utils.ChameleonColumn;
import me.eccentric_nz.TARDIS.chameleon.utils.CustomPreset;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;

public class TARDISCustomPreset {
    public static final HashMap<String, CustomPreset> CUSTOM_PRESETS = new HashMap();

    public void makePresets() {
        File file = new File(String.valueOf(TARDIS.plugin.getDataFolder()) + File.separator + "custom_presets.json");
        try (FileReader reader = new FileReader(file);){
            JsonObject rootObject = JsonParser.parseReader((JsonReader)new JsonReader((Reader)reader)).getAsJsonObject();
            for (Map.Entry entry : rootObject.entrySet()) {
                Material icon;
                TARDIS.plugin.debug("Adding custom chameleon preset: " + (String)entry.getKey());
                EnumMap<COMPASS, ChameleonColumn> blueprint = new EnumMap<COMPASS, ChameleonColumn>(COMPASS.class);
                EnumMap<COMPASS, ChameleonColumn> stained = new EnumMap<COMPASS, ChameleonColumn>(COMPASS.class);
                EnumMap<COMPASS, ChameleonColumn> glass = new EnumMap<COMPASS, ChameleonColumn>(COMPASS.class);
                ArrayList<String> lines = new ArrayList<String>();
                JsonObject custom = ((JsonElement)entry.getValue()).getAsJsonObject();
                JsonArray b = custom.get("blueprint").getAsJsonArray();
                JsonArray s = custom.get("stained").getAsJsonArray();
                JsonArray g = custom.get("glass").getAsJsonArray();
                for (COMPASS d : COMPASS.values()) {
                    blueprint.put(d, TARDISChameleonPreset.buildTARDISChameleonColumn(d, b));
                    stained.put(d, TARDISChameleonPreset.buildTARDISChameleonColumn(d, s));
                    glass.put(d, TARDISChameleonPreset.buildTARDISChameleonColumn(d, g));
                }
                for (JsonElement l : custom.get("sign").getAsJsonArray()) {
                    lines.add(l.getAsString());
                }
                try {
                    icon = Material.valueOf((String)custom.get("icon").getAsString());
                }
                catch (IllegalArgumentException e) {
                    icon = Material.ENDER_CHEST;
                }
                CUSTOM_PRESETS.put((String)entry.getKey(), new CustomPreset(blueprint, stained, glass, lines, icon));
            }
        }
        catch (IOException io) {
            TARDIS.plugin.getMessenger().message((CommandSender)TARDIS.plugin.getConsole(), TardisModule.WARNING, "Could not read custom presets file! " + io.getMessage());
        }
    }
}

