/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.brigadier.suggestions;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.io.File;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.Desktops;
import me.eccentric_nz.tardischunkgenerator.worldgen.utils.GallifeyStructureUtility;
import me.eccentric_nz.tardischunkgenerator.worldgen.utils.SiluriaStructureUtility;
import me.eccentric_nz.tardischunkgenerator.worldgen.utils.SkaroStructureUtility;

public class SchematicLoadSuggestions {
    public static CompletableFuture<Suggestions> get(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        String dir;
        switch (dir = StringArgumentType.getString(ctx, (String)"directory")) {
            case "console": {
                for (String c : Desktops.getBY_PERMS().keySet()) {
                    builder.suggest(c);
                }
                break;
            }
            case "room": {
                for (String r : TARDIS.plugin.getRoomsConfig().getConfigurationSection("rooms").getKeys(false)) {
                    builder.suggest(r.toLowerCase(Locale.ROOT));
                }
                break;
            }
            case "structure": {
                for (String g : GallifeyStructureUtility.structures) {
                    builder.suggest("gallifrey_" + g);
                }
                for (String s : SiluriaStructureUtility.structures) {
                    builder.suggest("siluria_" + s);
                }
                for (String d : SkaroStructureUtility.structures) {
                    builder.suggest("dalek_" + d);
                }
                break;
            }
            default: {
                File userDir = new File(String.valueOf(TARDIS.plugin.getDataFolder()) + File.separator + "user_schematics");
                if (!userDir.exists()) break;
                for (String f : userDir.list()) {
                    if (!f.endsWith(".tschm")) continue;
                    builder.suggest(f.substring(0, f.length() - 6));
                }
            }
        }
        return builder.buildFuture();
    }
}

