/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.brigadier.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;

public class TipsLimitArgumentType
implements CustomArgumentType<Integer, Integer> {
    private static final SimpleCommandExceptionType ERROR_INVALID_LIMIT = new SimpleCommandExceptionType((Message)MessageComponentSerializer.message().serialize((Component)Component.text((String)"Invalid TIPS limit specified!")));
    private final Set<Integer> LIMIT_SUBS = Set.of(Integer.valueOf(400), Integer.valueOf(800), Integer.valueOf(1200), Integer.valueOf(1600));

    public Integer parse(StringReader reader) {
        return 0;
    }

    public <S> Integer parse(StringReader reader, S source) throws CommandSyntaxException {
        int input = reader.readInt();
        if (!this.LIMIT_SUBS.contains(input)) {
            throw ERROR_INVALID_LIMIT.create();
        }
        return input;
    }

    public ArgumentType<Integer> getNativeType() {
        return IntegerArgumentType.integer((int)400, (int)1600);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        for (Integer i : this.LIMIT_SUBS) {
            builder.suggest(i.intValue());
        }
        return builder.buildFuture();
    }
}

