/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.brigadier.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.eccentric_nz.TARDIS.enumeration.Updateable;
import net.kyori.adventure.text.Component;

public class SecondaryArgumentType
implements CustomArgumentType<String, String> {
    private static final SimpleCommandExceptionType ERROR_INVALID_OPT = new SimpleCommandExceptionType((Message)MessageComponentSerializer.message().serialize((Component)Component.text((String)"Invalid secondary control specified!")));
    private final Set<String> SEC_SUBS = new HashSet<String>();

    public SecondaryArgumentType() {
        for (Updateable u : Updateable.values()) {
            if (!u.isSecondary()) continue;
            this.SEC_SUBS.add(u.getName());
        }
    }

    public String parse(StringReader reader) {
        return "";
    }

    public <S> String parse(StringReader reader, S source) throws CommandSyntaxException {
        String input = reader.readUnquotedString();
        if (!this.SEC_SUBS.contains(input)) {
            throw ERROR_INVALID_OPT.create();
        }
        return input;
    }

    public ArgumentType<String> getNativeType() {
        return StringArgumentType.word();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        for (String s : this.SEC_SUBS) {
            builder.suggest(s);
        }
        return builder.buildFuture();
    }
}

