/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.brigadier.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.RecipeCategory;
import me.eccentric_nz.TARDIS.enumeration.RecipeItem;
import net.kyori.adventure.text.Component;

public class RecipeArgumentType
implements CustomArgumentType<String, String> {
    private static final SimpleCommandExceptionType ERROR_INVALID_RECIPE = new SimpleCommandExceptionType((Message)MessageComponentSerializer.message().serialize((Component)Component.text((String)"Invalid recipe specified!")));
    private final Set<String> ROOT_SUBS = new HashSet<String>();

    public RecipeArgumentType(TARDIS plugin) {
        this.ROOT_SUBS.add("seed");
        this.ROOT_SUBS.add("tardis");
        for (RecipeItem recipeItem : RecipeItem.values()) {
            if (recipeItem.getCategory() == RecipeCategory.UNCRAFTABLE || recipeItem.getCategory() == RecipeCategory.UNUSED || recipeItem.getCategory() == RecipeCategory.CHEMISTRY) continue;
            this.ROOT_SUBS.add(recipeItem.toTabCompletionString());
        }
        for (String d : plugin.getCustomDoorsConfig().getKeys(false)) {
            this.ROOT_SUBS.add("door-" + d.toLowerCase(Locale.ROOT));
        }
        for (String r : plugin.getCustomRotorsConfig().getKeys(false)) {
            this.ROOT_SUBS.add("time-rotor-" + r.toLowerCase(Locale.ROOT));
        }
        for (String c : plugin.getCustomConsolesConfig().getConfigurationSection("consoles").getKeys(false)) {
            this.ROOT_SUBS.add("console-" + c.toLowerCase(Locale.ROOT));
        }
        if (!plugin.getConfig().getBoolean("modules.vortex_manipulator")) {
            this.ROOT_SUBS.remove("vortex-manipulator");
        }
        if (!plugin.getConfig().getBoolean("modules.regeneration")) {
            this.ROOT_SUBS.remove("elixir-of-life");
        }
        if (!plugin.getConfig().getBoolean("modules.sonic_blaster")) {
            this.ROOT_SUBS.remove("sonic-blaster");
            this.ROOT_SUBS.remove("blaster-battery");
            this.ROOT_SUBS.remove("landing-pad");
        }
        if (!plugin.getConfig().getBoolean("modules.weeping_angels")) {
            this.ROOT_SUBS.remove("judoon-ammunition");
            this.ROOT_SUBS.remove("k9");
        }
    }

    public String parse(StringReader reader) {
        return "";
    }

    public <S> String parse(StringReader reader, S source) throws CommandSyntaxException {
        String input = reader.readUnquotedString();
        if (!this.ROOT_SUBS.contains(input)) {
            throw ERROR_INVALID_RECIPE.create();
        }
        return input;
    }

    public ArgumentType<String> getNativeType() {
        return StringArgumentType.word();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        for (String d : this.ROOT_SUBS) {
            builder.suggest(d);
        }
        return builder.buildFuture();
    }
}

