/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.brigadier.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import net.kyori.adventure.text.Component;

public class PresetArgumentType
implements CustomArgumentType<String, String> {
    private static final SimpleCommandExceptionType ERROR_INVALID_PRESET = new SimpleCommandExceptionType((Message)MessageComponentSerializer.message().serialize((Component)Component.text((String)"Invalid chameleon preset specified!")));
    private final List<String> PRESET_SUBS = new ArrayList<String>();

    public PresetArgumentType(int includeFlags) {
        if (includeFlags == 1) {
            this.PRESET_SUBS.add("ALLOW");
            this.PRESET_SUBS.add("DENY");
        }
        if (includeFlags == 2) {
            this.PRESET_SUBS.add("OFF");
            this.PRESET_SUBS.add("ADAPT");
        }
        for (ChameleonPreset p : ChameleonPreset.values()) {
            this.PRESET_SUBS.add(p.toString());
        }
    }

    public String parse(StringReader reader) {
        return "";
    }

    public <S> String parse(StringReader reader, S source) throws CommandSyntaxException {
        String input = reader.readUnquotedString();
        if (!this.PRESET_SUBS.contains(input)) {
            throw ERROR_INVALID_PRESET.create();
        }
        return input;
    }

    public ArgumentType<String> getNativeType() {
        return StringArgumentType.word();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        for (String d : this.PRESET_SUBS) {
            builder.suggest(d);
        }
        for (String m : TARDIS.plugin.getCustomModelConfig().getConfigurationSection("models").getKeys(false)) {
            builder.suggest(m);
        }
        return builder.buildFuture();
    }
}

