/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.brigadier.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.eccentric_nz.TARDIS.blueprints.BlueprintType;
import net.kyori.adventure.text.Component;

public class BlueprintTypeArgumentType
implements CustomArgumentType<String, String> {
    private static final SimpleCommandExceptionType ERROR_INVALID_BP_TYPE = new SimpleCommandExceptionType((Message)MessageComponentSerializer.message().serialize((Component)Component.text((String)"Invalid blueprint type specified!")));
    private static final List<String> BLUEPRINT_TYPES = new ArrayList<String>();

    public String parse(StringReader reader) {
        return "";
    }

    public <S> String parse(StringReader reader, S source) throws CommandSyntaxException {
        String input = reader.readUnquotedString();
        if (!BLUEPRINT_TYPES.contains(input)) {
            throw ERROR_INVALID_BP_TYPE.create();
        }
        return input;
    }

    public ArgumentType<String> getNativeType() {
        return StringArgumentType.word();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        for (String b : BLUEPRINT_TYPES) {
            builder.suggest(b);
        }
        return builder.buildFuture();
    }

    static {
        for (BlueprintType type : BlueprintType.values()) {
            BLUEPRINT_TYPES.add(type.toString());
        }
    }
}

