/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.brigadier.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.eccentric_nz.TARDIS.blueprints.BlueprintBase;
import me.eccentric_nz.TARDIS.blueprints.BlueprintConsole;
import me.eccentric_nz.TARDIS.blueprints.BlueprintFeature;
import me.eccentric_nz.TARDIS.blueprints.BlueprintPreset;
import me.eccentric_nz.TARDIS.blueprints.BlueprintRoom;
import me.eccentric_nz.TARDIS.blueprints.BlueprintSonic;
import me.eccentric_nz.TARDIS.blueprints.BlueprintTravel;
import net.kyori.adventure.text.Component;

public class BlueprintArgumentType
implements CustomArgumentType<String, String> {
    private static final SimpleCommandExceptionType ERROR_INVALID_BLUEPRINT = new SimpleCommandExceptionType((Message)MessageComponentSerializer.message().serialize((Component)Component.text((String)"Invalid blueprint specified!")));
    private final Set<String> BLUEPRINT_SUBS = new HashSet<String>();

    public BlueprintArgumentType() {
        for (BlueprintBase blueprintBase : BlueprintBase.values()) {
            this.BLUEPRINT_SUBS.add("BLUEPRINT_BASE_" + blueprintBase.toString());
        }
        for (Enum enum_ : BlueprintConsole.values()) {
            this.BLUEPRINT_SUBS.add("BLUEPRINT_CONSOLE_" + enum_.toString());
        }
        for (Enum enum_ : BlueprintFeature.values()) {
            this.BLUEPRINT_SUBS.add("BLUEPRINT_FEATURE_" + enum_.toString());
        }
        for (Enum enum_ : BlueprintPreset.values()) {
            this.BLUEPRINT_SUBS.add("BLUEPRINT_PRESET_" + enum_.toString());
        }
        for (Enum enum_ : BlueprintRoom.values()) {
            this.BLUEPRINT_SUBS.add("BLUEPRINT_ROOM_" + enum_.toString());
        }
        for (Enum enum_ : BlueprintSonic.values()) {
            this.BLUEPRINT_SUBS.add("BLUEPRINT_SONIC_" + enum_.toString());
        }
        for (Enum enum_ : BlueprintTravel.values()) {
            this.BLUEPRINT_SUBS.add("BLUEPRINT_TRAVEL_" + enum_.toString());
        }
    }

    public String parse(StringReader reader) {
        return "";
    }

    public <S> String parse(StringReader reader, S source) throws CommandSyntaxException {
        String input = reader.readUnquotedString();
        if (!this.BLUEPRINT_SUBS.contains(input)) {
            throw ERROR_INVALID_BLUEPRINT.create();
        }
        return input;
    }

    public ArgumentType<String> getNativeType() {
        return StringArgumentType.word();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        for (String d : this.BLUEPRINT_SUBS) {
            builder.suggest(d);
        }
        return builder.buildFuture();
    }
}

