/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.brigadier;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.BlockPositionResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.PlayerProfileListResolver;
import io.papermc.paper.math.BlockPosition;
import java.util.Collection;
import java.util.Iterator;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.brigadier.arguments.UpdateableArgumentType;
import me.eccentric_nz.TARDIS.commands.preferences.IsomorphicCommand;
import me.eccentric_nz.TARDIS.commands.remote.BackCommand;
import me.eccentric_nz.TARDIS.commands.remote.ComehereCommand;
import me.eccentric_nz.TARDIS.commands.remote.HideCommand;
import me.eccentric_nz.TARDIS.commands.remote.RebuildCommand;
import me.eccentric_nz.TARDIS.commands.sudo.ARSUtility;
import me.eccentric_nz.TARDIS.commands.sudo.SudoARS;
import me.eccentric_nz.TARDIS.commands.sudo.SudoAssemble;
import me.eccentric_nz.TARDIS.commands.sudo.SudoDeadlock;
import me.eccentric_nz.TARDIS.commands.sudo.SudoDesiege;
import me.eccentric_nz.TARDIS.commands.sudo.SudoRepair;
import me.eccentric_nz.TARDIS.commands.sudo.SudoUpdate;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class SudoCommandNode {
    private final TARDIS plugin;

    public SudoCommandNode(TARDIS plugin) {
        this.plugin = plugin;
    }

    LiteralCommandNode<CommandSourceStack> build() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tardissudo").requires(ctx -> TARDISPermission.hasPermission(ctx.getSender(), "tardis.admin"))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"profile", (ArgumentType)ArgumentTypes.playerProfiles()).then(Commands.literal((String)"ars").executes(ctx -> {
            if (((CommandSourceStack)ctx.getSource()).getSender() instanceof ConsoleCommandSender) {
                this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "CMD_NO_CONSOLE");
                return 1;
            }
            PlayerProfileListResolver profilesResolver = (PlayerProfileListResolver)ctx.getArgument("profile", PlayerProfileListResolver.class);
            Collection foundProfiles = (Collection)profilesResolver.resolve((CommandSourceStack)ctx.getSource());
            Iterator iterator = foundProfiles.iterator();
            while (iterator.hasNext()) {
                ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
                PlayerProfile profile = (PlayerProfile)iterator.next();
                if (!rs.fromUUID(profile.getId().toString())) {
                    this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "PLAYER_NO_TARDIS");
                    return 1;
                }
                ARSUtility.checkARS(this.plugin, rs.getTardisId(), profile.getId().toString());
                new SudoARS(this.plugin).showARS((Player)((CommandSourceStack)ctx.getSource()).getSender(), profile.getId());
            }
            return 1;
        }))).then(Commands.literal((String)"assemble").executes(ctx -> {
            PlayerProfileListResolver profilesResolver = (PlayerProfileListResolver)ctx.getArgument("profile", PlayerProfileListResolver.class);
            Collection foundProfiles = (Collection)profilesResolver.resolve((CommandSourceStack)ctx.getSource());
            Iterator iterator = foundProfiles.iterator();
            while (iterator.hasNext()) {
                ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
                PlayerProfile profile = (PlayerProfile)iterator.next();
                if (!rs.fromUUID(profile.getId().toString())) {
                    this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "PLAYER_NO_TARDIS");
                    return 1;
                }
                OfflinePlayer offlinePlayer = this.plugin.getServer().getOfflinePlayer(profile.getId());
                new SudoAssemble(this.plugin).restore(((CommandSourceStack)ctx.getSource()).getSender(), profile.getId(), offlinePlayer.getName());
            }
            return 1;
        }))).then(Commands.literal((String)"back").executes(ctx -> {
            PlayerProfileListResolver profilesResolver = (PlayerProfileListResolver)ctx.getArgument("profile", PlayerProfileListResolver.class);
            Collection foundProfiles = (Collection)profilesResolver.resolve((CommandSourceStack)ctx.getSource());
            Iterator iterator = foundProfiles.iterator();
            while (iterator.hasNext()) {
                ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
                PlayerProfile profile = (PlayerProfile)iterator.next();
                if (!rs.fromUUID(profile.getId().toString())) {
                    this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "PLAYER_NO_TARDIS");
                    return 1;
                }
                OfflinePlayer offlinePlayer = this.plugin.getServer().getOfflinePlayer(profile.getId());
                new BackCommand(this.plugin).sendBack(((CommandSourceStack)ctx.getSource()).getSender(), rs.getTardisId(), offlinePlayer);
            }
            return 1;
        }))).then((ArgumentBuilder)Commands.literal((String)"chameleon"))).then(Commands.literal((String)"clean").executes(ctx -> {
            PlayerProfileListResolver profilesResolver = (PlayerProfileListResolver)ctx.getArgument("profile", PlayerProfileListResolver.class);
            Collection foundProfiles = (Collection)profilesResolver.resolve((CommandSourceStack)ctx.getSource());
            Iterator iterator = foundProfiles.iterator();
            while (iterator.hasNext()) {
                ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
                PlayerProfile profile = (PlayerProfile)iterator.next();
                if (!rs.fromUUID(profile.getId().toString())) {
                    this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "PLAYER_NO_TARDIS");
                    return 1;
                }
                new SudoRepair(this.plugin, profile.getId(), true).repair();
            }
            return 1;
        }))).then(Commands.literal((String)"come_here").executes(ctx -> {
            if (((CommandSourceStack)ctx.getSource()).getSender() instanceof ConsoleCommandSender) {
                this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "CMD_NO_CONSOLE");
                return 1;
            }
            PlayerProfileListResolver profilesResolver = (PlayerProfileListResolver)ctx.getArgument("profile", PlayerProfileListResolver.class);
            Collection foundProfiles = (Collection)profilesResolver.resolve((CommandSourceStack)ctx.getSource());
            Iterator iterator = foundProfiles.iterator();
            while (iterator.hasNext()) {
                ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
                PlayerProfile profile = (PlayerProfile)iterator.next();
                if (!rs.fromUUID(profile.getId().toString())) {
                    this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "PLAYER_NO_TARDIS");
                    return 1;
                }
                new ComehereCommand(this.plugin).doRemoteComeHere((Player)((CommandSourceStack)ctx.getSource()).getSender(), profile.getId());
            }
            return 1;
        }))).then(Commands.literal((String)"deadlock").executes(ctx -> {
            PlayerProfileListResolver profilesResolver = (PlayerProfileListResolver)ctx.getArgument("profile", PlayerProfileListResolver.class);
            Collection foundProfiles = (Collection)profilesResolver.resolve((CommandSourceStack)ctx.getSource());
            Iterator iterator = foundProfiles.iterator();
            while (iterator.hasNext()) {
                ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
                PlayerProfile profile = (PlayerProfile)iterator.next();
                if (!rs.fromUUID(profile.getId().toString())) {
                    this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "PLAYER_NO_TARDIS");
                    return 1;
                }
                new SudoDeadlock(this.plugin).toggleDeadlock(profile.getId(), ((CommandSourceStack)ctx.getSource()).getSender());
            }
            return 1;
        }))).then(Commands.literal((String)"desiege").executes(ctx -> {
            PlayerProfileListResolver profilesResolver = (PlayerProfileListResolver)ctx.getArgument("profile", PlayerProfileListResolver.class);
            Collection foundProfiles = (Collection)profilesResolver.resolve((CommandSourceStack)ctx.getSource());
            Iterator iterator = foundProfiles.iterator();
            while (iterator.hasNext()) {
                ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
                PlayerProfile profile = (PlayerProfile)iterator.next();
                if (!rs.fromUUID(profile.getId().toString())) {
                    this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "PLAYER_NO_TARDIS");
                    return 1;
                }
                OfflinePlayer offlinePlayer = this.plugin.getServer().getOfflinePlayer(profile.getId());
                if (offlinePlayer.isOnline()) {
                    new SudoDesiege(this.plugin).restore(((CommandSourceStack)ctx.getSource()).getSender(), profile.getId(), rs.getTardisId());
                    continue;
                }
                this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "NOT_ONLINE");
            }
            return 1;
        }))).then((ArgumentBuilder)Commands.literal((String)"handbrake"))).then(Commands.literal((String)"hide").executes(ctx -> {
            PlayerProfileListResolver profilesResolver = (PlayerProfileListResolver)ctx.getArgument("profile", PlayerProfileListResolver.class);
            Collection foundProfiles = (Collection)profilesResolver.resolve((CommandSourceStack)ctx.getSource());
            Iterator iterator = foundProfiles.iterator();
            while (iterator.hasNext()) {
                ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
                PlayerProfile profile = (PlayerProfile)iterator.next();
                if (!rs.fromUUID(profile.getId().toString())) {
                    this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "PLAYER_NO_TARDIS");
                    return 1;
                }
                new HideCommand(this.plugin).doRemoteHide(((CommandSourceStack)ctx.getSource()).getSender(), rs.getTardisId());
            }
            return 1;
        }))).then(Commands.literal((String)"isomorphic").executes(ctx -> {
            PlayerProfileListResolver profilesResolver = (PlayerProfileListResolver)ctx.getArgument("profile", PlayerProfileListResolver.class);
            Collection foundProfiles = (Collection)profilesResolver.resolve((CommandSourceStack)ctx.getSource());
            Iterator iterator = foundProfiles.iterator();
            while (iterator.hasNext()) {
                ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
                PlayerProfile profile = (PlayerProfile)iterator.next();
                if (!rs.fromUUID(profile.getId().toString())) {
                    this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "PLAYER_NO_TARDIS");
                    return 1;
                }
                new IsomorphicCommand(this.plugin).toggleIsomorphicControls(profile.getId(), ((CommandSourceStack)ctx.getSource()).getSender());
            }
            return 1;
        }))).then(Commands.literal((String)"rebuild").executes(ctx -> {
            PlayerProfileListResolver profilesResolver = (PlayerProfileListResolver)ctx.getArgument("profile", PlayerProfileListResolver.class);
            Collection foundProfiles = (Collection)profilesResolver.resolve((CommandSourceStack)ctx.getSource());
            Iterator iterator = foundProfiles.iterator();
            while (iterator.hasNext()) {
                ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
                PlayerProfile profile = (PlayerProfile)iterator.next();
                if (!rs.fromUUID(profile.getId().toString())) {
                    this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "PLAYER_NO_TARDIS");
                    return 1;
                }
                OfflinePlayer offlinePlayer = this.plugin.getServer().getOfflinePlayer(profile.getId());
                new RebuildCommand(this.plugin).doRemoteRebuild(((CommandSourceStack)ctx.getSource()).getSender(), rs.getTardisId(), offlinePlayer, true);
            }
            return 1;
        }))).then(Commands.literal((String)"repair").executes(ctx -> {
            PlayerProfileListResolver profilesResolver = (PlayerProfileListResolver)ctx.getArgument("profile", PlayerProfileListResolver.class);
            Collection foundProfiles = (Collection)profilesResolver.resolve((CommandSourceStack)ctx.getSource());
            Iterator iterator = foundProfiles.iterator();
            while (iterator.hasNext()) {
                ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
                PlayerProfile profile = (PlayerProfile)iterator.next();
                if (!rs.fromUUID(profile.getId().toString())) {
                    this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "PLAYER_NO_TARDIS");
                    return 1;
                }
                new SudoRepair(this.plugin, profile.getId(), false).repair();
            }
            return 1;
        }))).then(Commands.literal((String)"travel").then(Commands.argument((String)"world", (ArgumentType)ArgumentTypes.world()).then(Commands.argument((String)"coords", (ArgumentType)ArgumentTypes.blockPosition()).executes(ctx -> {
            PlayerProfileListResolver profilesResolver = (PlayerProfileListResolver)ctx.getArgument("profile", PlayerProfileListResolver.class);
            Collection foundProfiles = (Collection)profilesResolver.resolve((CommandSourceStack)ctx.getSource());
            Iterator iterator = foundProfiles.iterator();
            while (iterator.hasNext()) {
                ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
                PlayerProfile profile = (PlayerProfile)iterator.next();
                if (!rs.fromUUID(profile.getId().toString())) {
                    this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "PLAYER_NO_TARDIS");
                    return 1;
                }
                OfflinePlayer offlinePlayer = this.plugin.getServer().getOfflinePlayer(profile.getId());
                World world = (World)ctx.getArgument("world", World.class);
                BlockPositionResolver resolver = (BlockPositionResolver)ctx.getArgument("coords", BlockPositionResolver.class);
                BlockPosition pos = (BlockPosition)resolver.resolve((CommandSourceStack)ctx.getSource());
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "tardisremote " + offlinePlayer.getName() + " travel " + world.getName() + " " + pos.blockX() + " " + pos.blockY() + " " + pos.blockZ());
            }
            return 1;
        }))))).then(Commands.literal((String)"update").then(((RequiredArgumentBuilder)Commands.argument((String)"what", (ArgumentType)new UpdateableArgumentType()).executes(ctx -> {
            if (((CommandSourceStack)ctx.getSource()).getSender() instanceof ConsoleCommandSender) {
                this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "CMD_NO_CONSOLE");
                return 1;
            }
            PlayerProfileListResolver profilesResolver = (PlayerProfileListResolver)ctx.getArgument("profile", PlayerProfileListResolver.class);
            Collection foundProfiles = (Collection)profilesResolver.resolve((CommandSourceStack)ctx.getSource());
            Iterator iterator = foundProfiles.iterator();
            while (iterator.hasNext()) {
                ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
                PlayerProfile profile = (PlayerProfile)iterator.next();
                if (!rs.fromUUID(profile.getId().toString())) {
                    this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "PLAYER_NO_TARDIS");
                    return 1;
                }
                String u = (String)ctx.getArgument("what", String.class);
                new SudoUpdate(this.plugin).initiate((Player)((CommandSourceStack)ctx.getSource()).getSender(), u, "", rs.getTardisId(), profile.getId());
            }
            return 1;
        })).then(Commands.argument((String)"extra", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            if (((String)ctx.getArgument("what", String.class)).equals("HINGE")) {
                builder.suggest("LEFT");
                builder.suggest("RIGHT");
            } else {
                builder.suggest("lock");
                builder.suggest("unlock");
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            if (((CommandSourceStack)ctx.getSource()).getSender() instanceof ConsoleCommandSender) {
                this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "CMD_NO_CONSOLE");
                return 1;
            }
            PlayerProfileListResolver profilesResolver = (PlayerProfileListResolver)ctx.getArgument("profile", PlayerProfileListResolver.class);
            Collection foundProfiles = (Collection)profilesResolver.resolve((CommandSourceStack)ctx.getSource());
            Iterator iterator = foundProfiles.iterator();
            while (iterator.hasNext()) {
                ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
                PlayerProfile profile = (PlayerProfile)iterator.next();
                if (!rs.fromUUID(profile.getId().toString())) {
                    this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "PLAYER_NO_TARDIS");
                    return 1;
                }
                String u = (String)ctx.getArgument("what", String.class);
                String e = StringArgumentType.getString((CommandContext)ctx, (String)"extra");
                new SudoUpdate(this.plugin).initiate((Player)((CommandSourceStack)ctx.getSource()).getSender(), u, e, rs.getTardisId(), profile.getId());
            }
            return 1;
        })))));
        return command.build();
    }
}

