/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.brigadier;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.brigadier.arguments.TranslatableLanguageArgumentType;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.universaltranslator.Language;
import me.eccentric_nz.TARDIS.universaltranslator.LingvaTranslate;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SayCommandNode {
    private final TARDIS plugin;

    public SayCommandNode(TARDIS plugin) {
        this.plugin = plugin;
    }

    LiteralCommandNode<CommandSourceStack> build() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tardissay").requires(ctx -> TARDISPermission.hasPermission(ctx.getSender(), "tardis.translate"))).then(Commands.argument((String)"language", (ArgumentType)new TranslatableLanguageArgumentType()).then(Commands.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String preferred = this.getPreferredLanguage((CommandContext<CommandSourceStack>)ctx);
            String lang = (String)ctx.getArgument("language", String.class);
            String whatToTranslate = StringArgumentType.getString((CommandContext)ctx, (String)"message");
            try {
                Language from = Language.valueOf(preferred);
                Language to = Language.valueOf(lang);
                try {
                    LingvaTranslate translate = new LingvaTranslate(this.plugin, from.getCode(), to.getCode(), whatToTranslate);
                    translate.fetchAsync((hasResult, translated) -> {
                        if (hasResult) {
                            this.plugin.getServer().dispatchCommand(((CommandSourceStack)ctx.getSource()).getSender(), "say [" + TardisModule.TRANSLATOR.getName() + "] " + translated.getTranslated());
                        }
                    });
                    return 1;
                }
                catch (CommandException ex) {
                    this.plugin.debug("Could not get translation! " + ex.getMessage());
                    this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TRANSLATOR, "YT_UNAVAILABLE");
                }
            }
            catch (IllegalArgumentException e) {
                this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TRANSLATOR, "LANG_NOT_VALID");
            }
            return 1;
        })));
        return command.build();
    }

    private String getPreferredLanguage(CommandContext<CommandSourceStack> ctx) {
        Player player;
        ResultSetPlayerPrefs rs;
        String preferedLang = "ENGLISH";
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        if (commandSender instanceof Player && (rs = new ResultSetPlayerPrefs(this.plugin, (player = (Player)commandSender).getUniqueId().toString())).resultSet() && !rs.getLanguage().isEmpty() && !rs.getLanguage().equalsIgnoreCase("AUTO_DETECT")) {
            preferedLang = rs.getLanguage();
        }
        return preferedLang;
    }
}

