/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.brigadier;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.BlockPositionResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.PlayerProfileListResolver;
import io.papermc.paper.math.BlockPosition;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.brigadier.arguments.AreasArgumentType;
import me.eccentric_nz.TARDIS.commands.TARDISCommandHelper;
import me.eccentric_nz.TARDIS.commands.remote.BackCommand;
import me.eccentric_nz.TARDIS.commands.remote.ComehereCommand;
import me.eccentric_nz.TARDIS.commands.remote.HideCommand;
import me.eccentric_nz.TARDIS.commands.remote.RebuildCommand;
import me.eccentric_nz.TARDIS.commands.remote.RemoteUtility;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class RemoteCommandNode {
    private final TARDIS plugin;

    public RemoteCommandNode(TARDIS plugin) {
        this.plugin = plugin;
    }

    LiteralCommandNode<CommandSourceStack> build() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tardisremote").requires(ctx -> TARDISPermission.hasPermission(ctx.getSender(), "tardis.remote"))).executes(ctx -> {
            new TARDISCommandHelper(this.plugin).getCommand("tardisremote", ((CommandSourceStack)ctx.getSource()).getSender());
            return 1;
        })).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)ArgumentTypes.playerProfiles()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"travel").then(Commands.literal((String)"home").executes(ctx -> {
            Pair<Tardis, OfflinePlayer> required = this.getRequired((CommandContext<CommandSourceStack>)ctx);
            if (required == null) {
                return 1;
            }
            if (RemoteUtility.travelCheck(this.plugin, ((CommandSourceStack)ctx.getSource()).getSender(), ((Tardis)required.getFirst()).isHandbrakeOn(), ((Tardis)required.getFirst()).getArtronLevel())) {
                return 1;
            }
            if (((CommandSourceStack)ctx.getSource()).getSender() instanceof BlockCommandSender && ((OfflinePlayer)required.getSecond()).getPlayer() == null) {
                return 1;
            }
            RemoteUtility.home(this.plugin, ((Tardis)required.getFirst()).getTardisId(), ((CommandSourceStack)ctx.getSource()).getSender(), ((OfflinePlayer)required.getSecond()).getUniqueId());
            return 1;
        }))).then(Commands.literal((String)"area").then(Commands.argument((String)"name", (ArgumentType)new AreasArgumentType()).executes(ctx -> {
            Pair<Tardis, OfflinePlayer> required = this.getRequired((CommandContext<CommandSourceStack>)ctx);
            if (required == null) {
                return 1;
            }
            if (RemoteUtility.travelCheck(this.plugin, ((CommandSourceStack)ctx.getSource()).getSender(), ((Tardis)required.getFirst()).isHandbrakeOn(), ((Tardis)required.getFirst()).getArtronLevel())) {
                return 1;
            }
            if (((CommandSourceStack)ctx.getSource()).getSender() instanceof BlockCommandSender && ((OfflinePlayer)required.getSecond()).getPlayer() == null) {
                return 1;
            }
            String a = (String)ctx.getArgument("name", String.class);
            RemoteUtility.area(this.plugin, ((CommandSourceStack)ctx.getSource()).getSender(), a, (OfflinePlayer)required.getSecond(), ((Tardis)required.getFirst()).getTardisId(), ((Tardis)required.getFirst()).getPreset().equals((Object)ChameleonPreset.INVISIBLE));
            return 1;
        })))).then(Commands.argument((String)"world", (ArgumentType)ArgumentTypes.world()).then(Commands.argument((String)"coords", (ArgumentType)ArgumentTypes.blockPosition()).executes(ctx -> {
            Pair<Tardis, OfflinePlayer> required = this.getRequired((CommandContext<CommandSourceStack>)ctx);
            if (required == null) {
                return 1;
            }
            if (RemoteUtility.travelCheck(this.plugin, ((CommandSourceStack)ctx.getSource()).getSender(), ((Tardis)required.getFirst()).isHandbrakeOn(), ((Tardis)required.getFirst()).getArtronLevel())) {
                return 1;
            }
            if (((CommandSourceStack)ctx.getSource()).getSender() instanceof BlockCommandSender && ((OfflinePlayer)required.getSecond()).getPlayer() == null) {
                return 1;
            }
            World world = (World)ctx.getArgument("world", World.class);
            BlockPositionResolver resolver = (BlockPositionResolver)ctx.getArgument("coords", BlockPositionResolver.class);
            BlockPosition pos = (BlockPosition)resolver.resolve((CommandSourceStack)ctx.getSource());
            RemoteUtility.coordinates(this.plugin, ((CommandSourceStack)ctx.getSource()).getSender(), world, pos, (OfflinePlayer)required.getSecond(), ((Tardis)required.getFirst()).getTardisId());
            return 1;
        }))))).then(Commands.literal((String)"come_here").executes(ctx -> {
            Pair<Tardis, OfflinePlayer> required = this.getRequired((CommandContext<CommandSourceStack>)ctx);
            if (required == null) {
                return 1;
            }
            CommandSender patt0$temp = ((CommandSourceStack)ctx.getSource()).getSender();
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                if (((CommandSourceStack)ctx.getSource()).getSender().hasPermission("tardis.admin")) {
                    new ComehereCommand(this.plugin).doRemoteComeHere(player, ((OfflinePlayer)required.getSecond()).getUniqueId());
                    return 1;
                }
            }
            this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "NO_PERMS");
            return 1;
        }))).then(Commands.literal((String)"hide").executes(ctx -> {
            Pair<Tardis, OfflinePlayer> required = this.getRequired((CommandContext<CommandSourceStack>)ctx);
            if (required == null) {
                return 1;
            }
            if (((CommandSourceStack)ctx.getSource()).getSender() instanceof Player && !((CommandSourceStack)ctx.getSource()).getSender().hasPermission("tardis.admin") || ((CommandSourceStack)ctx.getSource()).getSender() instanceof BlockCommandSender) {
                new me.eccentric_nz.TARDIS.commands.tardis.HideCommand(this.plugin).hide((OfflinePlayer)required.getSecond());
            } else {
                new HideCommand(this.plugin).doRemoteHide(((CommandSourceStack)ctx.getSource()).getSender(), ((Tardis)required.getFirst()).getTardisId());
            }
            return 1;
        }))).then(Commands.literal((String)"rebuild").executes(ctx -> {
            Pair<Tardis, OfflinePlayer> required = this.getRequired((CommandContext<CommandSourceStack>)ctx);
            if (required == null) {
                return 1;
            }
            if (((CommandSourceStack)ctx.getSource()).getSender() instanceof Player && !((CommandSourceStack)ctx.getSource()).getSender().hasPermission("tardis.admin") || ((CommandSourceStack)ctx.getSource()).getSender() instanceof BlockCommandSender) {
                new me.eccentric_nz.TARDIS.commands.tardis.RebuildCommand(this.plugin).rebuildPreset((OfflinePlayer)required.getSecond());
            } else {
                new RebuildCommand(this.plugin).doRemoteRebuild(((CommandSourceStack)ctx.getSource()).getSender(), ((Tardis)required.getFirst()).getTardisId(), (OfflinePlayer)required.getSecond(), ((Tardis)required.getFirst()).isHidden());
            }
            return 1;
        }))).then(Commands.literal((String)"back").executes(ctx -> {
            Pair<Tardis, OfflinePlayer> required = this.getRequired((CommandContext<CommandSourceStack>)ctx);
            if (required == null) {
                return 1;
            }
            if (((CommandSourceStack)ctx.getSource()).getSender() instanceof Player && ((CommandSourceStack)ctx.getSource()).getSender().hasPermission("tardis.admin") || ((CommandSourceStack)ctx.getSource()).getSender() instanceof ConsoleCommandSender) {
                if (!((Tardis)required.getFirst()).isHandbrakeOn()) {
                    this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "NOT_WHILE_TRAVELLING");
                    return 1;
                }
                new BackCommand(this.plugin).sendBack(((CommandSourceStack)ctx.getSource()).getSender(), ((Tardis)required.getFirst()).getTardisId(), (OfflinePlayer)required.getSecond());
            } else {
                this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "NO_PERMS");
            }
            return 1;
        })));
        return command.build();
    }

    private Pair<Tardis, OfflinePlayer> getRequired(CommandContext<CommandSourceStack> ctx) {
        try {
            PlayerProfileListResolver profilesResolver = (PlayerProfileListResolver)ctx.getArgument("profile", PlayerProfileListResolver.class);
            Collection foundProfiles = (Collection)profilesResolver.resolve((CommandSourceStack)ctx.getSource());
            Iterator iterator = foundProfiles.iterator();
            if (iterator.hasNext()) {
                PlayerProfile profile = (PlayerProfile)iterator.next();
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("uuid", profile.getId().toString());
                ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
                if (!rs.resultSet()) {
                    this.plugin.getMessenger().send(((CommandSourceStack)ctx.getSource()).getSender(), TardisModule.TARDIS, "PLAYER_NO_TARDIS");
                    return null;
                }
                Tardis t = rs.getTardis();
                if (RemoteUtility.check(this.plugin, ((CommandSourceStack)ctx.getSource()).getSender(), t.getTardisId())) {
                    return null;
                }
                OfflinePlayer o = this.plugin.getServer().getOfflinePlayer(profile.getId());
                return new Pair((Object)t, (Object)o);
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return null;
    }
}

