/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.arch;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.arch.ArchDisguise;
import me.eccentric_nz.TARDIS.arch.ArchInventory;
import me.eccentric_nz.TARDIS.arch.ArchLibsDisguise;
import me.eccentric_nz.TARDIS.arch.ArchPersister;
import me.eccentric_nz.TARDIS.arch.FobWatchData;
import me.eccentric_nz.TARDIS.arch.RandomArchName;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TARDISArchCommand {
    private final TARDIS plugin;

    public TARDISArchCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void getTime(Player player) {
        long now;
        UUID uuid = player.getUniqueId();
        if (!this.plugin.getTrackerKeeper().getJohnSmith().containsKey(uuid)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCH_NOT_VALID");
            return;
        }
        long time = this.plugin.getTrackerKeeper().getJohnSmith().get(uuid).getTime();
        long diff = time - (now = System.currentTimeMillis());
        if (diff > 0L) {
            String sub0 = String.format("%d", diff / 60000L % 60L);
            String sub1 = String.format("%d", diff / 1000L % 60L);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCH_TIME", sub0, sub1);
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARCH_FREE");
        }
    }

    public void whois(CommandSender sender, String name) {
        for (Player p : this.plugin.getServer().getOnlinePlayers()) {
            if (!ComponentUtils.stripColour(p.playerListName()).equalsIgnoreCase(name)) continue;
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARCH_PLAYER", p.getName());
            return;
        }
        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "COULD_NOT_FIND_NAME");
    }

    public void force(Player player) {
        UUID uuid = player.getUniqueId();
        boolean inv = this.plugin.getConfig().getBoolean("arch.switch_inventory");
        if (!this.plugin.getTrackerKeeper().getJohnSmith().containsKey(uuid)) {
            String name = RandomArchName.name();
            long time = System.currentTimeMillis() + this.plugin.getConfig().getLong("arch.min_time") * 60000L;
            FobWatchData twd = new FobWatchData(name, time);
            this.plugin.getTrackerKeeper().getJohnSmith().put(uuid, twd);
            if (this.plugin.isDisguisesOnServer()) {
                ArchLibsDisguise.undisguise(player);
            } else {
                ArchDisguise.undisguise(player);
            }
            player.getWorld().strikeLightningEffect(player.getLocation());
            double mh = player.getAttribute(Attribute.MAX_HEALTH).getValue();
            player.setHealth(mh / 10.0);
            if (inv) {
                new ArchInventory().switchInventories(player, 0);
            }
            if (this.plugin.isDisguisesOnServer()) {
                ArchLibsDisguise.disguise(player, name);
            } else {
                ArchDisguise.disguise(player, name);
            }
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                TextComponent component = Component.text((String)name);
                player.displayName((Component)component);
                player.playerListName((Component)component);
            }, 5L);
        } else {
            if (this.plugin.isDisguisesOnServer()) {
                ArchLibsDisguise.undisguise(player);
            } else {
                ArchDisguise.undisguise(player);
            }
            if (inv) {
                new ArchInventory().switchInventories(player, 1);
            }
            player.getWorld().strikeLightningEffect(player.getLocation());
            this.plugin.getTrackerKeeper().getJohnSmith().remove(uuid);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                TextComponent component = Component.text((String)player.getName());
                player.displayName((Component)component);
                player.playerListName((Component)component);
            }, 5L);
            new ArchPersister(this.plugin).removeArch(uuid);
        }
    }
}

