/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.advanced;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.SerializeInventory;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDestinations;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDiskStorage;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DiskWriterCommand {
    private static final Pattern LETTERS_NUMBERS = Pattern.compile("[A-Za-z0-9_*]{2,16}");
    private final TARDIS plugin;
    private final List<String> disks = new ArrayList<String>();

    public DiskWriterCommand(TARDIS plugin) {
        this.plugin = plugin;
        this.disks.add("Save Storage Disk");
        this.disks.add("Player Storage Disk");
        this.disks.add("Biome Storage Disk");
        this.disks.add("Preset Storage Disk");
    }

    public void writeSave(Player player, String name) {
        ItemMeta im;
        ItemStack is;
        boolean makeAndSaveDisk;
        boolean bl = makeAndSaveDisk = !this.plugin.getConfig().getBoolean("difficulty.disk_in_hand_for_write");
        if (makeAndSaveDisk) {
            is = ItemStack.of((Material)Material.MUSIC_DISC_CHIRP, (int)1);
            im = is.getItemMeta();
            im.displayName((Component)Component.text((String)"Save Storage Disk"));
            im.lore(List.of(Component.text((String)"Blank")));
            is.setItemMeta(im);
        } else {
            is = player.getInventory().getItemInMainHand();
        }
        if (is.hasItemMeta() && (im = is.getItemMeta()).hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "Save Storage Disk")) {
            List lore = im.lore();
            if (!ComponentUtils.stripColour((Component)lore.getFirst()).equals("Blank")) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_ONLY_BLANK");
                return;
            }
            if (!LETTERS_NUMBERS.matcher(name).matches()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_NAME_NOT_VALID");
                return;
            }
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", player.getUniqueId().toString());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (!rs.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
            } else {
                boolean isSpace;
                Tardis tardis = rs.getTardis();
                int id = tardis.getTardisId();
                ChameleonPreset preset = tardis.getPreset();
                HashMap<String, Object> wherename = new HashMap<String, Object>();
                wherename.put("tardis_id", id);
                wherename.put("dest_name", name);
                wherename.put("type", 0);
                ResultSetDestinations rsd = new ResultSetDestinations(this.plugin, wherename, false);
                if (rsd.resultSet()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_EXISTS");
                    return;
                }
                ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                if (!rsc.resultSet()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                    return;
                }
                Current current = rsc.getCurrent();
                lore.set(0, Component.text((String)name));
                lore.add(1, Component.text((String)current.location().getWorld().getName()));
                lore.add(2, Component.text((int)current.location().getBlockX()));
                lore.add(3, Component.text((int)current.location().getBlockY()));
                lore.add(4, Component.text((int)current.location().getBlockZ()));
                lore.add(5, Component.text((String)preset.toString()));
                lore.add(6, Component.text((String)current.direction().toString()));
                lore.add(7, Component.text((String)(current.submarine() ? "true" : "false")));
                im.lore(lore);
                is.setItemMeta(im);
                if (makeAndSaveDisk && !(isSpace = this.saveDiskToStorage(player, is))) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_STORAGE_FULL");
                    return;
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_LOC_SAVED");
            }
        }
    }

    private boolean saveDiskToStorage(Player player, ItemStack is) {
        UUID uuid = player.getUniqueId();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid.toString());
        ResultSetDiskStorage rs = new ResultSetDiskStorage(this.plugin, where);
        if (rs.resultSet()) {
            try {
                ItemStack[] saves1 = SerializeInventory.itemStacksFromString(rs.getSavesOne());
                int slot = this.getNextFreeSlot(saves1);
                if (slot != -1) {
                    saves1[slot] = is;
                    String serialized = SerializeInventory.itemStacksToString(saves1);
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    set.put("saves_one", serialized);
                    HashMap<String, Object> whereu = new HashMap<String, Object>();
                    whereu.put("uuid", uuid.toString());
                    this.plugin.getQueryFactory().doUpdate("storage", set, whereu);
                    return true;
                }
                ItemStack[] saves2 = SerializeInventory.itemStacksFromString(rs.getSavesTwo());
                slot = this.getNextFreeSlot(saves2);
                if (slot != -1) {
                    saves2[slot] = is;
                    String serialized = SerializeInventory.itemStacksToString(saves2);
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    set.put("saves_two", serialized);
                    HashMap<String, Object> whereu = new HashMap<String, Object>();
                    whereu.put("uuid", uuid.toString());
                    this.plugin.getQueryFactory().doUpdate("storage", set, whereu);
                    return true;
                }
                return false;
            }
            catch (IOException ex) {
                this.plugin.debug("Could not get save disks: " + String.valueOf(ex));
            }
        }
        return false;
    }

    private int getNextFreeSlot(ItemStack[] stack) {
        int slot = -1;
        for (int s = 27; s < stack.length; ++s) {
            ItemStack disk = stack[s];
            if (disk != null) continue;
            slot = s;
            break;
        }
        return slot;
    }

    public void writePlayer(Player player, Player target) {
        ItemMeta im;
        ItemStack is = player.getInventory().getItemInMainHand();
        if (is.hasItemMeta() && (im = is.getItemMeta()).hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "Player Storage Disk")) {
            List lore = im.lore();
            if (!ComponentUtils.stripColour((Component)lore.getFirst()).equals("Blank")) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_ONLY_BLANK");
                return;
            }
            if (player.getName().equalsIgnoreCase(target.getName())) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_NO_SAVE");
                return;
            }
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", player.getUniqueId().toString());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (!rs.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
            } else {
                lore.set(0, Component.text((String)target.getName()));
                im.lore(lore);
                is.setItemMeta(im);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_PLAYER_SAVED");
            }
        }
    }

    public void eraseDisk(Player player) {
        ItemStack is = player.getInventory().getItemInMainHand();
        if (is.hasItemMeta() && this.disks.contains(ComponentUtils.stripColour(is.getItemMeta().displayName()))) {
            ItemMeta im = is.getItemMeta();
            im.lore(List.of(Component.text((String)"Blank")));
            is.setItemMeta(im);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_ERASE");
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_HAND_ERASE");
        }
    }

    public void writeSaveToControlDisk(Player player, String name) {
        ItemMeta im;
        ItemStack is = player.getInventory().getItemInMainHand();
        if (is.hasItemMeta() && (im = is.getItemMeta()).hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "Authorised Control Disk") && im.getPersistentDataContainer().has(this.plugin.getTimeLordUuidKey(), this.plugin.getPersistentDataTypeUUID())) {
            ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
            if (!rs.fromUUID(player.getUniqueId().toString())) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
            } else {
                String save;
                if (name.equalsIgnoreCase("home")) {
                    save = "Home";
                } else {
                    HashMap<String, Object> wherename = new HashMap<String, Object>();
                    wherename.put("tardis_id", rs.getTardisId());
                    wherename.put("dest_name", name);
                    wherename.put("type", 0);
                    ResultSetDestinations rsd = new ResultSetDestinations(this.plugin, wherename, false);
                    if (!rsd.resultSet()) {
                        this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "SAVE_NOT_FOUND", "/tardis list saves", this.plugin);
                        return;
                    }
                    save = name;
                }
                List lore = im.lore();
                lore.add(Component.text((String)save));
                im.lore(lore);
                is.setItemMeta(im);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_LOC_SAVED");
            }
        }
    }
}

