/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.ARS.relocator;

import com.destroystokyo.paper.MaterialTags;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.ARS.JettisonSlot;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.desktop.BlockScannerData;
import me.eccentric_nz.TARDIS.enumeration.UseClay;
import me.eccentric_nz.TARDIS.schematic.SchematicGZip;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;

public class RoomBlockScanner {
    private final TARDIS plugin;
    private final String room;
    private final JettisonSlot jettison;
    private final UUID uuid;
    private int count = 0;

    public RoomBlockScanner(TARDIS plugin, String room, JettisonSlot jettison, UUID uuid) {
        this.plugin = plugin;
        this.room = room;
        this.jettison = jettison;
        this.uuid = uuid;
    }

    public BlockScannerData check() {
        Material floor_type;
        Material wall_type;
        JsonObject obj = SchematicGZip.getObject(this.plugin, "rooms", this.room.toLowerCase(Locale.ROOT), false);
        if (obj == null) {
            return null;
        }
        JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
        int h = dimensions.get("height").getAsInt();
        int w = dimensions.get("width").getAsInt();
        int l = dimensions.get("length").getAsInt();
        float v = h * w * l;
        int starty = this.jettison.getY();
        int startx = this.jettison.getX();
        int startz = this.jettison.getZ();
        World world = this.jettison.getChunk().getWorld();
        ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, this.uuid.toString());
        if (rsp.resultSet()) {
            wall_type = Material.getMaterial((String)rsp.getWall());
            floor_type = Material.getMaterial((String)rsp.getFloor());
        } else {
            wall_type = Material.ORANGE_WOOL;
            floor_type = Material.LIGHT_GRAY_WOOL;
        }
        JsonArray arr = obj.get("input").getAsJsonArray();
        for (int level = 0; level < h; ++level) {
            JsonArray floor = arr.get(level).getAsJsonArray();
            for (int row = 0; row < w; ++row) {
                JsonArray r = (JsonArray)floor.get(row);
                for (int col = 0; col < l; ++col) {
                    Material material;
                    UseClay use_clay;
                    JsonObject c = r.get(col).getAsJsonObject();
                    int x = startx + row;
                    int y = starty + level;
                    int z = startz + col;
                    BlockData data = this.plugin.getServer().createBlockData(c.get("data").getAsString());
                    Material type = data.getMaterial();
                    Block b = world.getBlockAt(x, y, z);
                    if (type.equals((Object)Material.ORANGE_WOOL)) {
                        type = wall_type;
                    }
                    if (type.equals((Object)Material.LIGHT_GRAY_WOOL)) {
                        type = floor_type;
                    }
                    if (type.equals((Object)Material.SPONGE)) {
                        type = Material.AIR;
                    }
                    if (type.equals((Object)Material.CAKE)) {
                        type = Material.LEVER;
                    }
                    if (type.equals((Object)Material.SPAWNER)) {
                        type = Material.OAK_BUTTON;
                    }
                    if (type.equals((Object)Material.MUSHROOM_STEM)) {
                        type = Material.REPEATER;
                    }
                    if (MaterialTags.INFESTED_BLOCKS.isTagged(type)) {
                        type = Material.AIR;
                    }
                    if (type.equals((Object)Material.BEDROCK)) {
                        type = Material.GLASS;
                    }
                    if (type.equals((Object)Material.COMMAND_BLOCK)) {
                        type = Material.STONE_BRICKS;
                    }
                    if (type.equals((Object)Material.JUKEBOX) || type.equals((Object)Material.NOTE_BLOCK)) {
                        type = Material.MUSHROOM_STEM;
                    }
                    if (!Tag.WOOL.isTagged((Keyed)type)) continue;
                    try {
                        use_clay = UseClay.valueOf(this.plugin.getConfig().getString("creation.use_clay"));
                    }
                    catch (IllegalArgumentException e) {
                        use_clay = UseClay.WOOL;
                    }
                    if (type == Material.ORANGE_WOOL) {
                        String[] tsplit = type.toString().split("_");
                        String m = tsplit.length > 2 ? tsplit[0] + "_" + tsplit[1] + "_" + String.valueOf((Object)use_clay) : tsplit[0] + "_" + String.valueOf((Object)use_clay);
                        type = Material.getMaterial((String)m);
                    }
                    if (type.isAir()) {
                        v -= 1.0f;
                    }
                    if ((material = b.getType()).equals((Object)Material.BARRIER) || material.equals((Object)type) || material.isAir() && type.isAir()) continue;
                    ++this.count;
                }
            }
        }
        int changed = (int)((float)this.count / v * 100.0f);
        boolean allow = changed < this.plugin.getConfig().getInt("desktop.block_change_percent");
        return new BlockScannerData(changed, this.count, v, allow, "");
    }
}

