/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.ood;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.database.data.Follower;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngelSpawnEvent;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.monsters.ood.OodEquipment;
import me.eccentric_nz.tardisweepingangels.nms.MonsterSpawner;
import me.eccentric_nz.tardisweepingangels.nms.TWAFollower;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class VillagerSpawnListener
implements Listener {
    private final TARDIS plugin;

    public VillagerSpawnListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onVillagerSpawnEvent(CreatureSpawnEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.getType().equals((Object)EntityType.VILLAGER)) {
            return;
        }
        World world = entity.getWorld();
        if (!this.plugin.getMonstersConfig().getBoolean("ood.worlds." + world.getName())) {
            return;
        }
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER) {
            return;
        }
        if (TARDISConstants.RANDOM.nextInt(100) < this.plugin.getMonstersConfig().getInt("ood.spawn_from_villager")) {
            TWAFollower follower = new MonsterSpawner().createFollower(entity.getLocation(), new Follower(UUID.randomUUID(), TARDISWeepingAngels.UNCLAIMED, Monster.OOD));
            LivingEntity ood = (LivingEntity)follower.getBukkitEntity();
            OodEquipment.set(null, ood, false);
            this.plugin.getServer().getPluginManager().callEvent((Event)new TARDISWeepingAngelSpawnEvent((Entity)ood, EntityType.HUSK, Monster.OOD, entity.getLocation()));
            entity.remove();
        }
    }
}

