/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisvortexmanipulator.command;

import java.util.HashMap;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.tardisvortexmanipulator.TVMUtils;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMQueryFactory;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMResultSetInbox;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMResultSetManipulator;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMResultSetMessageById;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMResultSetOutbox;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TVMCommandMessage {
    private final TARDIS plugin;

    public TVMCommandMessage(TARDIS plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean process(Player player, String[] args) {
        if (!TARDISPermission.hasPermission(player, "vm.message")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_PERM_CMD");
            return true;
        }
        if (args.length < 3) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_USAGE");
            return false;
        }
        String first = args[1].toUpperCase(Locale.ROOT);
        try {
            MessageAction f = MessageAction.valueOf(first);
            switch (f.ordinal()) {
                case 0: {
                    OfflinePlayer ofp = this.plugin.getServer().getOfflinePlayer(args[2]);
                    if (ofp == null) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "COULD_NOT_FIND_NAME");
                        return true;
                    }
                    String ofp_uuid = ofp.getUniqueId().toString();
                    TVMResultSetManipulator rsofp = new TVMResultSetManipulator(this.plugin, ofp_uuid);
                    if (!rsofp.resultSet()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_NONE", args[2]);
                        return true;
                    }
                    StringBuilder sb = new StringBuilder();
                    int i = 3;
                    while (true) {
                        if (i >= args.length) {
                            String message = sb.toString();
                            HashMap<String, Object> whereofp = new HashMap<String, Object>();
                            whereofp.put("uuid_to", ofp_uuid);
                            whereofp.put("uuid_from", player.getUniqueId().toString());
                            whereofp.put("message", message);
                            whereofp.put("date", System.currentTimeMillis());
                            this.plugin.getQueryFactory().doInsert("messages", whereofp);
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_MSG_SENT");
                            return true;
                        }
                        sb.append(args[i]).append(" ");
                        ++i;
                    }
                }
                case 1: {
                    String uuid = player.getUniqueId().toString();
                    if (args.length == 3) {
                        if (args[2].equalsIgnoreCase("out")) {
                            TVMResultSetOutbox rso = new TVMResultSetOutbox(this.plugin, uuid, 0, 10);
                            if (!rso.resultSet()) {
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_MSG_OUT");
                                return true;
                            }
                            TVMUtils.sendOutboxList(player, rso, 1);
                        } else {
                            TVMResultSetInbox rsi = new TVMResultSetInbox(this.plugin, uuid, 0, 10);
                            if (!rsi.resultSet()) {
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_MSG_IN");
                                return true;
                            }
                            TVMUtils.sendInboxList(player, rsi, 1);
                        }
                    }
                    if (args.length < 4) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_MSG_PAGE");
                        return true;
                    }
                    int page = TARDISNumberParsers.parseInt(args[3]);
                    if (page == 0) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_MSG_INVALID");
                        return true;
                    }
                    int start = page * 10 - 10;
                    int limit = page * 10;
                    if (args[2].equalsIgnoreCase("out")) {
                        TVMResultSetOutbox rso = new TVMResultSetOutbox(this.plugin, uuid, start, limit);
                        if (rso.resultSet()) {
                            TVMUtils.sendOutboxList(player, rso, page);
                            return true;
                        }
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_MSG_OUT");
                        return true;
                    }
                    TVMResultSetInbox rsi = new TVMResultSetInbox(this.plugin, uuid, start, limit);
                    if (rsi.resultSet()) {
                        TVMUtils.sendInboxList(player, rsi, page);
                        return true;
                    }
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_MSG_IN");
                    return true;
                }
                case 2: {
                    int read_id = TARDISNumberParsers.parseInt(args[2]);
                    if (read_id == 0) return true;
                    TVMResultSetMessageById rsm = new TVMResultSetMessageById(this.plugin, read_id);
                    if (rsm.resultSet()) {
                        TVMUtils.readMessage(player, rsm.getMessage());
                        new TVMQueryFactory(this.plugin).setReadStatus(read_id);
                        return true;
                    }
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_MSG_ID");
                    return true;
                }
                case 3: {
                    int delete_id = TARDISNumberParsers.parseInt(args[2]);
                    if (delete_id != 0) {
                        TVMResultSetMessageById rsm = new TVMResultSetMessageById(this.plugin, delete_id);
                        if (!rsm.resultSet()) return true;
                        HashMap<String, Object> where = new HashMap<String, Object>();
                        where.put("message_id", delete_id);
                        this.plugin.getQueryFactory().doDelete("messages", where);
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_MSG_DELETED");
                        return true;
                    }
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_MSG_ID");
                    return true;
                }
            }
            if (!args[2].toLowerCase(Locale.ROOT).equals("in") && !args[2].toLowerCase(Locale.ROOT).equals("out")) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_MSG_CLEAR");
                return true;
            }
            HashMap<String, Object> where = new HashMap<String, Object>();
            String which = "Outbox";
            if (args[2].equalsIgnoreCase("out")) {
                where.put("uuid_from", player.getUniqueId().toString());
            } else {
                where.put("uuid_to", player.getUniqueId().toString());
                which = "Inbox";
            }
            this.plugin.getQueryFactory().doDelete("messages", where);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_MSG_CLEARED", which);
            return true;
        }
        catch (IllegalArgumentException e) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_USAGE");
            return false;
        }
    }

    private static enum MessageAction {
        MSG,
        LIST,
        READ,
        DELETE,
        CLEAR;

    }
}

