/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.travel;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.flight.TARDISLand;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TARDISRescue {
    private final TARDIS plugin;

    public TARDISRescue(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean rescue(Player player, UUID saved, int id, COMPASS d, boolean rescue, boolean request) {
        TravelType travelType;
        int move;
        if (this.plugin.getServer().getPlayer(saved) == null) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ONLINE");
            return false;
        }
        Location player_loc = this.plugin.getServer().getPlayer(saved).getLocation();
        if (this.plugin.getTardisArea().isInExistingArea(player_loc)) {
            this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "PLAYER_IN_AREA", "/tardistravel area [area name]", this.plugin);
            return false;
        }
        if (!request && !this.plugin.getPluginRespect().getRespect(player_loc, new Parameters(player, Flag.getDefaultFlags()))) {
            return false;
        }
        if (!this.plugin.getPlanetsConfig().getBoolean("planets." + player_loc.getWorld().getName() + ".time_travel")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_WORLD_TRAVEL");
            return false;
        }
        World w = player_loc.getWorld();
        int[] start_loc = TARDISTimeTravel.getStartLocation(player_loc, d);
        int count = TARDISTimeTravel.safeLocation(start_loc[0] - (move = rescue ? 0 : 3), player_loc.getBlockY(), start_loc[2], start_loc[1] - move, start_loc[3], w, d);
        if (count > 0) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "RESCUE_NOT_SAFE");
            return false;
        }
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("world", player_loc.getWorld().getName());
        set.put("x", player_loc.getBlockX() - move);
        set.put("y", player_loc.getBlockY());
        set.put("z", player_loc.getBlockZ());
        set.put("direction", d.toString());
        set.put("submarine", 0);
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        this.plugin.getQueryFactory().doSyncUpdate("next", set, where);
        TravelType travelType2 = travelType = rescue ? TravelType.RESCUE : TravelType.PLAYER;
        if (!rescue) {
            this.plugin.getMessenger().send(player, "RESCUE_SET", !this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id));
            if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                new TARDISLand(this.plugin, id, player).exitVortex();
                this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, travelType, id));
            }
        }
        this.plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(this.plugin.getArtronConfig().getInt("travel"), travelType));
        if (rescue) {
            this.plugin.getTrackerKeeper().getRescue().put(id, saved);
        }
        return true;
    }

    public RescueData tryRescue(Player player, UUID saved, boolean request) {
        if (!(!TARDISPermission.hasPermission(player, "tardis.timetravel") || TARDISPermission.hasPermission(player, "tardis.exile") && this.plugin.getConfig().getBoolean("travel.exile"))) {
            int travel;
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", player.getUniqueId().toString());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (!rs.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
                return new RescueData(false, 0);
            }
            Tardis tardis = rs.getTardis();
            int id = tardis.getTardisId();
            if (!tardis.isHandbrakeOn() && !this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_TRAVELLING");
                return new RescueData(false, 0);
            }
            HashMap<String, Object> wheret = new HashMap<String, Object>();
            wheret.put("uuid", player.getUniqueId().toString());
            ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheret, false);
            if (!rst.resultSet() && !this.plugin.getTrackerKeeper().getTelepathicRescue().containsKey(saved)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_IN_TARDIS");
                return new RescueData(false, 0);
            }
            int tardis_id = rst.getTardis_id();
            if (tardis_id != id && !this.plugin.getTrackerKeeper().getTelepathicRescue().containsKey(saved)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CMD_ONLY_TL");
                return new RescueData(false, 0);
            }
            int level = tardis.getArtronLevel();
            if (level < (travel = this.plugin.getArtronConfig().getInt("travel"))) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ENOUGH_ENERGY");
                return new RescueData(false, 0);
            }
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            if (!rsc.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                return new RescueData(false, 0);
            }
            return new RescueData(this.rescue(player, saved, id, rsc.getCurrent().direction(), !request, request), id);
        }
        return new RescueData(false, 0);
    }

    public static class RescueData {
        private final boolean success;
        private final int tardis_id;

        RescueData(boolean success, int id) {
            this.success = success;
            this.tardis_id = id;
        }

        public boolean success() {
            return this.success;
        }

        public int getTardis_id() {
            return this.tardis_id;
        }
    }
}

