/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.sonic;

import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.advanced.CircuitChecker;
import me.eccentric_nz.TARDIS.advanced.CircuitDamager;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.utility.SculkShrieker;
import me.eccentric_nz.TARDIS.console.interaction.SonicConsoleRecharge;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.custommodels.keys.SonicItem;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.data.Throticle;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoors;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetSonicLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetThrottle;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.flight.TARDISTakeoff;
import me.eccentric_nz.TARDIS.rotors.Rotor;
import me.eccentric_nz.TARDIS.rotors.TimeRotor;
import me.eccentric_nz.TARDIS.sonic.SonicLore;
import me.eccentric_nz.TARDIS.sonic.actions.SonicRecharge;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.Handbrake;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import me.eccentric_nz.TARDIS.utility.protection.TARDISLWCChecker;
import net.kyori.adventure.text.Component;
import nl.rutgerkok.blocklocker.BlockLockerAPIv2;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class SonicDock {
    private final TARDIS plugin;

    public SonicDock(TARDIS plugin) {
        this.plugin = plugin;
    }

    public static ItemFrame getItemFrame(int id) {
        Location location;
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        where.put("type", 48);
        ResultSetControls rsc = new ResultSetControls(TARDIS.plugin, where, false);
        if (rsc.resultSet() && (location = TARDISStaticLocationGetters.getLocationFromBukkitString(rsc.getLocation())) != null) {
            BoundingBox box = new BoundingBox((double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ(), (double)(location.getBlockX() + 1), (double)(location.getBlockY() + 1), (double)(location.getBlockZ() + 1));
            for (Entity e2 : location.getWorld().getNearbyEntities(box, e -> e.getType() == EntityType.ITEM_FRAME)) {
                ItemFrame frame;
                if (!(e2 instanceof ItemFrame) || (frame = (ItemFrame)e2).getItem().getType() != Material.FLOWER_POT) continue;
                return frame;
            }
        }
        return null;
    }

    public void dock(int id, Interaction interaction, Player player, ItemStack sonic) {
        if (TARDISDisplayItemUtils.getSonic(interaction) != null) {
            return;
        }
        ItemDisplay display = this.doDocking(sonic, interaction.getLocation(), new Vector(0.0, 0.75, 0.1), player, id);
        display.setRotation(0.0f, 15.0f);
        if (this.plugin.getConfig().getBoolean("sonic.charge")) {
            long delay = this.plugin.getConfig().getLong("sonic.charge_level") / this.plugin.getConfig().getLong("sonic.charge_interval");
            SonicConsoleRecharge recharge = new SonicConsoleRecharge(this.plugin, display.getUniqueId(), interaction, id, player);
            int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)recharge, 1L, delay);
            recharge.setTask(task);
        }
    }

    public void dock(int id, ItemFrame frame, Player player, ItemStack sonic) {
        Block block = frame.getLocation().getBlock();
        if (TARDISDisplayItemUtils.get(block) != null) {
            return;
        }
        ItemDisplay display = this.doDocking(sonic, block.getLocation(), new Vector(0.5, 0.5, 0.5), player, id);
        this.updateModel(frame, SonicItem.SONIC_DOCK_ON.getKey(), false);
        if (this.plugin.getConfig().getBoolean("sonic.charge")) {
            long delay = this.plugin.getConfig().getLong("sonic.charge_level") / this.plugin.getConfig().getLong("sonic.charge_interval");
            SonicRecharge recharge = new SonicRecharge(this.plugin, display.getUniqueId(), frame, id, player);
            int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)recharge, 1L, delay);
            recharge.setTask(task);
        }
    }

    private ItemDisplay doDocking(ItemStack sonic, Location location, Vector vector, Player player, int id) {
        sonic.removeEnchantment(Enchantment.UNBREAKING);
        ItemMeta im = sonic.getItemMeta();
        im.setEnchantmentGlintOverride(null);
        sonic.setItemMeta(im);
        UUID uuid = (UUID)sonic.getItemMeta().getPersistentDataContainer().get(this.plugin.getSonicUuidKey(), this.plugin.getPersistentDataTypeUUID());
        ItemDisplay display = (ItemDisplay)location.getWorld().spawnEntity(location.clone().add(vector), EntityType.ITEM_DISPLAY);
        display.setItemStack(sonic);
        display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.FIXED);
        display.setBillboard(Display.Billboard.FIXED);
        display.setInvulnerable(true);
        player.getInventory().setItemInMainHand(null);
        if (uuid != null) {
            Location destination;
            ResultSetSonicLocation rssc = new ResultSetSonicLocation(this.plugin, uuid);
            if (rssc.resultset() && (destination = rssc.getLocation()) != null) {
                if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                    return display;
                }
                if (this.plugin.getTrackerKeeper().getDispersedTARDII().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NOT_WHILE_DISPERSED");
                    return display;
                }
                if (this.plugin.getTrackerKeeper().getInVortex().contains(id) || this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getDematerialising().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_MAT");
                    return display;
                }
                if (!this.plugin.getConfig().getBoolean("travel.include_default_world") && this.plugin.getConfig().getBoolean("creation.default_world") && destination.getWorld().getName().equals(this.plugin.getConfig().getString("creation.default_world_name"))) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_WORLD_TRAVEL");
                    return display;
                }
                if (!this.plugin.getPluginRespect().getRespect(destination, new Parameters(player, Flag.getDefaultFlags()))) {
                    return display;
                }
                if (TARDISPermission.hasPermission(player, "tardis.exile") && this.plugin.getConfig().getBoolean("travel.exile")) {
                    String areaPerm = this.plugin.getTardisArea().getExileArea(player);
                    if (this.plugin.getTardisArea().areaCheckInExile(areaPerm, destination)) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "EXILE_NO_TRAVEL");
                        return display;
                    }
                }
                if (this.plugin.getTardisArea().isInExistingArea(destination)) {
                    this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "AREA_NO_SONIC", "/tardistravel area [area name]", this.plugin);
                    return display;
                }
                String world = destination.getWorld().getName();
                if (!this.plugin.getPlanetsConfig().getBoolean("planets." + world + ".time_travel")) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PB_IN_WORLD");
                    return display;
                }
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("tardis_id", id);
                ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
                if (rs.resultSet()) {
                    Tardis tardis = rs.getTardis();
                    if (this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
                        return display;
                    }
                    CircuitChecker tcc = new CircuitChecker(this.plugin, id);
                    tcc.getCircuits();
                    if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(player, true) && !tcc.hasMaterialisation()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_MAT_CIRCUIT");
                        return display;
                    }
                    if (this.plugin.getConfig().getBoolean("circuits.damage") && this.plugin.getConfig().getInt("circuits.uses.materialisation") > 0) {
                        int uses_left = tcc.getMaterialisationUses();
                        new CircuitDamager(this.plugin, DiskCircuit.MATERIALISATION, uses_left, id, player).damage();
                    }
                    COMPASS player_direction = COMPASS.valueOf(TARDISStaticUtils.getPlayersDirection(player, false));
                    int[] start_loc = TARDISTimeTravel.getStartLocation(destination, player_direction);
                    int count = TARDISTimeTravel.safeLocation(start_loc[0], destination.getBlockY(), start_loc[2], start_loc[1], start_loc[3], destination.getWorld(), player_direction);
                    Block under = destination.getBlock().getRelative(BlockFace.DOWN);
                    if (this.plugin.getPM().isPluginEnabled("BlockLocker") && (BlockLockerAPIv2.isProtected((Block)destination.getBlock()) || BlockLockerAPIv2.isProtected((Block)under))) {
                        count = 1;
                    }
                    if (this.plugin.getPM().isPluginEnabled("LWC") && new TARDISLWCChecker().isBlockProtected(destination.getBlock(), under, player)) {
                        count = 1;
                    }
                    if (count > 0) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WOULD_GRIEF_BLOCKS");
                        return display;
                    }
                    Throticle throticle = new ResultSetThrottle(this.plugin).getSpeedAndParticles(player.getUniqueId().toString());
                    int ch = Math.round((float)this.plugin.getArtronConfig().getInt("comehere") * throticle.throttle().getArtronMultiplier());
                    if (tardis.getArtronLevel() < ch) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ENOUGH_ENERGY");
                        return display;
                    }
                    HashMap<String, Object> tid = new HashMap<String, Object>();
                    tid.put("tardis_id", id);
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    set.put("world", destination.getWorld().getName());
                    set.put("x", destination.getBlockX());
                    set.put("y", destination.getBlockY());
                    set.put("z", destination.getBlockZ());
                    set.put("submarine", 0);
                    this.plugin.getQueryFactory().doSyncUpdate("next", set, tid);
                    this.plugin.getMessenger().send(player, "LOC_SAVED", true);
                    this.plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(this.plugin.getArtronConfig().getInt("travel"), TravelType.RANDOM));
                    this.plugin.getTrackerKeeper().getRescue().remove(id);
                    if (new Handbrake(this.plugin).isRelativityDifferentiated(id)) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SONIC_DEST");
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "HANDBRAKE_OFF");
                        HashMap<String, Object> whereh = new HashMap<String, Object>();
                        whereh.put("tardis_id", id);
                        whereh.put("type", 0);
                        whereh.put("secondary", 0);
                        ResultSetControls rsh = new ResultSetControls(this.plugin, whereh, false);
                        if (rsh.resultSet()) {
                            if (this.isDoorOpen(id)) {
                                this.plugin.getMessenger().sendStatus(player, "DOOR_CLOSE");
                                this.plugin.getTrackerKeeper().getHasClickedHandbrake().add(id);
                                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getTrackerKeeper().getHasClickedHandbrake().removeAll(Collections.singleton(id)), 600L);
                                return display;
                            }
                            ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, player.getUniqueId().toString());
                            if (rsp.resultSet()) {
                                Location handbrake_loc = TARDISStaticLocationGetters.getLocationFromBukkitString(rsh.getLocation());
                                new TARDISTakeoff(this.plugin).run(id, handbrake_loc.getBlock(), handbrake_loc, player, rsp.isBeaconOn(), tardis.getBeacon(), rsp.isTravelbarOn(), throticle);
                                if (tardis.getRotor() != null) {
                                    if (tardis.getRotor() == TARDISConstants.UUID_ZERO) {
                                        SculkShrieker.setRotor(id);
                                    } else {
                                        ItemFrame itemFrame = TimeRotor.getItemFrame(tardis.getRotor());
                                        if (itemFrame != null) {
                                            Rotor rotor = Rotor.getByModel(TimeRotor.getRotorModel(itemFrame));
                                            TimeRotor.setRotor(rotor, itemFrame);
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        this.plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(this.plugin.getArtronConfig().getInt("comehere"), TravelType.SONIC_DOCK));
                        this.plugin.getMessenger().send(player, "SONIC_DEST", true);
                    }
                }
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DOCK_NOT_SCANNED");
        }
        return display;
    }

    public void undock(Interaction interaction, Player player) {
        ItemDisplay display = TARDISDisplayItemUtils.getSonic(interaction);
        if (display == null) {
            return;
        }
        this.doUndock(display, player);
    }

    public void undock(ItemFrame frame, Player player) {
        ItemDisplay display = TARDISDisplayItemUtils.getFromBoundingBox(frame.getLocation().getBlock());
        if (display == null) {
            return;
        }
        this.doUndock(display, player);
        this.updateModel(frame, SonicItem.SONIC_DOCK_OFF.getKey(), true);
    }

    private void doUndock(ItemDisplay display, Player player) {
        ItemStack sonic = display.getItemStack();
        SonicLore.setChargeLevel(sonic);
        if (player.getInventory().getItemInMainHand().getType() == Material.AIR) {
            player.getInventory().setItemInMainHand(sonic);
        } else {
            player.getInventory().addItem(new ItemStack[]{sonic});
        }
        display.remove();
    }

    private void updateModel(ItemFrame frame, NamespacedKey model, boolean setDisplay) {
        ItemStack dock = frame.getItem();
        ItemMeta im = dock.getItemMeta();
        im.setItemModel(model);
        if (setDisplay) {
            im.displayName((Component)ComponentUtils.toWhite("Sonic Dock"));
        }
        dock.setItemMeta(im);
        frame.setItem(dock);
        frame.setSilent(true);
    }

    private boolean isDoorOpen(int id) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        where.put("door_type", 1);
        ResultSetDoors rs = new ResultSetDoors(this.plugin, where, false);
        if (rs.resultSet()) {
            Block door = TARDISStaticLocationGetters.getLocationFromDB(rs.getDoor_location()).getBlock();
            return TARDISStaticUtils.isDoorOpen(door);
        }
        return false;
    }
}

