/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.siegemode;

import org.bukkit.Chunk;
import org.bukkit.Location;

public class SiegeArea {
    private static final int MIN_Y = 48;
    private static final int MAX_Y = 80;
    private final int id;
    private int minX;
    private int maxX;
    private int minZ;
    private int maxZ;

    public SiegeArea(int id, Chunk chunk) {
        this.id = id;
        this.setMinMaxXZ(chunk);
    }

    private void setMinMaxXZ(Chunk chunk) {
        this.minX = this.getChunkX(true, chunk);
        this.maxX = this.getChunkX(false, chunk);
        this.minZ = this.getChunkZ(true, chunk);
        this.maxZ = this.getChunkZ(false, chunk);
    }

    private int getChunkX(boolean min, Chunk c) {
        int cx = c.getX();
        int cz = c.getZ();
        if (min) {
            return c.getWorld().getChunkAt(cx - 4, cz).getBlock(0, 64, 0).getX();
        }
        return c.getWorld().getChunkAt(cx + 4, cz).getBlock(0, 64, 0).getX();
    }

    private int getChunkZ(boolean min, Chunk c) {
        int cx = c.getX();
        int cz = c.getZ();
        if (min) {
            return c.getWorld().getChunkAt(cx, cz - 4).getBlock(0, 64, 0).getZ();
        }
        return c.getWorld().getChunkAt(cx, cz + 4).getBlock(0, 64, 0).getZ();
    }

    boolean isInSiegeArea(Location l) {
        int x = l.getBlockX();
        int y = l.getBlockY();
        int z = l.getBlockZ();
        return x >= this.minX && x <= this.maxX && y >= 48 && y <= 80 && z >= this.minZ && z <= this.maxZ;
    }

    public int getId() {
        return this.id;
    }
}

